/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.remote.iterator;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteIterator;

public class ArrayIterator
implements RemoteIterator,
Serializable {
    private Object[] elements;
    private int position;

    public ArrayIterator(Object[] elements) {
        this.elements = elements;
        this.position = 0;
    }

    public long getSize() {
        if (this.elements == null) {
            return this.position;
        }
        return this.elements.length;
    }

    public void skip(long items) throws IllegalArgumentException, NoSuchElementException {
        if (items < 0L) {
            throw new IllegalArgumentException("Negative skip is not allowed");
        }
        if (this.elements == null || items > (long)this.elements.length) {
            throw new NoSuchElementException("Skipped past the last element");
        }
        int rest = this.elements.length - (int)items;
        Object[] tmp = null;
        if (rest > 0) {
            tmp = new Object[this.elements.length - (int)items];
            System.arraycopy(this.elements, (int)items, tmp, 0, tmp.length);
        }
        this.elements = tmp;
        this.position = (int)((long)this.position + items);
    }

    public Object[] nextObjects() throws IllegalArgumentException {
        if (this.elements == null) {
            return null;
        }
        Object[] tmp = this.elements;
        this.position += this.elements.length;
        this.elements = null;
        return tmp;
    }
}

