/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.value;

import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.rmi.api.value.BaseNonStreamValue;
import org.exoplatform.services.jcr.rmi.api.value.StatefulValue;

public class DoubleValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = 1008752925622023274L;
    private final double value;

    protected DoubleValue(double value) {
        this.value = value;
    }

    protected DoubleValue(String value) throws ValueFormatException {
        this(DoubleValue.toDouble(value));
    }

    protected static double toDouble(String value) throws ValueFormatException {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException((Throwable)e);
        }
    }

    public int getType() {
        return 4;
    }

    public Calendar getDate() throws ValueFormatException {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis((long)this.value);
        return date;
    }

    public double getDouble() {
        return this.value;
    }

    public String getString() {
        return Double.toString(this.value);
    }

    public long getLong() {
        return (long)this.value;
    }

    public long getLength() {
        return this.getString().length();
    }

    public int getOrderNumber() {
        return 0;
    }
}

