/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.impl.server.iterator;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.jcr.RangeIterator;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteIterator;
import org.exoplatform.services.jcr.rmi.impl.server.ServerObject;

public abstract class ServerIterator
extends ServerObject
implements RemoteIterator {
    private final RangeIterator iterator;
    private final int maxBufferSize;
    private long size;

    public ServerIterator(RangeIterator iterator, RemoteAdapterFactory factory, int maxBufferSize) throws RemoteException {
        super(factory);
        this.iterator = iterator;
        this.maxBufferSize = maxBufferSize;
        this.size = -2L;
    }

    public long getSize() throws RemoteException {
        if (this.size == -2L) {
            this.size = this.iterator.getSize();
        }
        return this.size;
    }

    public void skip(long items) throws NoSuchElementException, RemoteException {
        try {
            this.iterator.skip(items);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    protected abstract Object getRemoteObject(Object var1) throws RemoteException;

    public Object[] nextObjects() throws RemoteException {
        if (!this.iterator.hasNext()) {
            return null;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        while (items.size() < this.maxBufferSize && this.iterator.hasNext()) {
            items.add(this.getRemoteObject(this.iterator.next()));
        }
        if (!this.iterator.hasNext()) {
            this.size = this.iterator.getPosition();
        }
        return items.toArray();
    }
}

