/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.client;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.jcr.Repository;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.exoplatform.services.jcr.rmi.api.client.LocalAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.client.LocalAdapterFactoryImpl;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteRepository;

public class ClientRepositoryFactory
implements ObjectFactory {
    public static final String URL_PARAMETER = "url";
    private LocalAdapterFactory factory;

    public ClientRepositoryFactory() {
        this(new LocalAdapterFactoryImpl());
    }

    public ClientRepositoryFactory(LocalAdapterFactory factory) {
        this.factory = factory;
    }

    public synchronized Repository getRepository(String url) throws ClassCastException, MalformedURLException, NotBoundException, RemoteException {
        RemoteRepository remote = (RemoteRepository)Naming.lookup(url);
        return this.factory.getRepository(remote);
    }

    private Repository getRepository(RefAddr url) throws NamingException {
        try {
            return this.getRepository((String)url.getContent());
        }
        catch (Exception ex) {
            throw new NamingException(ex.getMessage());
        }
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable environment) throws NamingException {
        if (object instanceof Reference) {
            RefAddr url;
            Reference reference = (Reference)object;
            if (Repository.class.getName().equals(reference.getClassName()) && (url = reference.get(URL_PARAMETER)) != null) {
                return this.getRepository(url);
            }
        }
        return null;
    }
}

