/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.rest.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnLockCommand {
    protected final NullResourceLocksHolder nullResourceLocks;

    public UnLockCommand(NullResourceLocksHolder nullResourceLocks) {
        this.nullResourceLocks = nullResourceLocks;
    }

    public Response unLock(Session session, String path, List<String> tokens) {
        try {
            try {
                Node node = (Node)session.getItem(path);
                if (node.isLocked()) {
                    node.unlock();
                    session.save();
                }
                return Response.Builder.noContent().build();
            }
            catch (PathNotFoundException exc) {
                if (this.nullResourceLocks.isLocked(session, path)) {
                    this.nullResourceLocks.checkLock(session, path, tokens);
                    this.nullResourceLocks.removeLock(session, path);
                    return Response.Builder.noContent().build();
                }
                return Response.Builder.notFound().errorMessage(exc.getMessage()).build();
            }
        }
        catch (LockException e) {
            return Response.Builder.withStatus((int)423).errorMessage(e.getMessage()).build();
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }
}

