/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.version.Version;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.rest.Response;

public class UnCheckOutCommand {
    public Response uncheckout(Session session, String path) {
        try {
            Node node = session.getRootNode().getNode(TextUtil.relativizePath(path));
            Version restoreVersion = node.getBaseVersion();
            node.restore(restoreVersion, true);
            return Response.Builder.ok().build();
        }
        catch (UnsupportedRepositoryOperationException e) {
            return Response.Builder.withStatus((int)409).errorMessage(e.getMessage()).build();
        }
        catch (LockException e) {
            return Response.Builder.withStatus((int)423).errorMessage(e.getMessage()).build();
        }
        catch (PathNotFoundException e) {
            return Response.Builder.notFound().errorMessage(e.getMessage()).build();
        }
        catch (RepositoryException e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }
}

