/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MkColCommand {
    private static Log log = ExoLogger.getLogger((String)"jcr.MkColCommand");
    private final NullResourceLocksHolder nullResourceLocks;

    public MkColCommand(NullResourceLocksHolder nullResourceLocks) {
        this.nullResourceLocks = nullResourceLocks;
    }

    public Response mkCol(Session session, String path, String nodeType, List<String> mixinTypes, List<String> tokens) {
        try {
            this.nullResourceLocks.checkLock(session, path, tokens);
            Node node = session.getRootNode().addNode(TextUtil.relativizePath(path), nodeType);
            if (mixinTypes != null) {
                this.addMixins(node, mixinTypes);
            }
            session.save();
        }
        catch (ItemExistsException e) {
            return Response.Builder.withStatus((int)405).build();
        }
        catch (PathNotFoundException e) {
            return Response.Builder.withStatus((int)409).build();
        }
        catch (AccessDeniedException e) {
            return Response.Builder.withStatus((int)403).build();
        }
        catch (LockException e) {
            return Response.Builder.withStatus((int)423).build();
        }
        catch (RepositoryException e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
        return Response.Builder.withStatus((int)201).build();
    }

    private void addMixins(Node node, List<String> mixinTypes) {
        for (int i = 0; i < mixinTypes.size(); ++i) {
            String curMixinType = mixinTypes.get(i);
            try {
                node.addMixin(curMixinType);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)("Can't add mixin [" + curMixinType + "]"));
            }
        }
    }
}

