/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.common.util.MediaType;
import org.exoplatform.common.util.MediaTypeHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.webdav.Range;
import org.exoplatform.services.jcr.webdav.resource.CollectionResource;
import org.exoplatform.services.jcr.webdav.resource.FileResource;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.resource.VersionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedFileResource;
import org.exoplatform.services.jcr.webdav.util.MultipartByterangesEntity;
import org.exoplatform.services.jcr.webdav.util.RangedInputStream;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.transformer.OutputEntityTransformer;
import org.exoplatform.services.rest.transformer.SerializableTransformer;
import org.exoplatform.services.rest.transformer.XSLT4SourceOutputTransformer;
import org.exoplatform.services.xml.transform.impl.trax.TRAXTemplatesServiceImpl;
import org.exoplatform.services.xml.transform.trax.TRAXTemplatesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCommand {
    public Response get(Session session, String path, String version, String ifModifiedSince, String baseURI, List<Range> ranges, HashMap<MediaType, String> cacheControls) {
        if (null == version && path.indexOf("?version=") > 0) {
            version = path.substring(path.indexOf("?version=") + "?version=".length());
            path = path.substring(0, path.indexOf("?version="));
        }
        try {
            Node node = (Node)session.getItem(path);
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            URI uri = new URI(TextUtil.escape(baseURI + node.getPath(), '%', true));
            if (ResourceUtil.isFile(node)) {
                InputStream istream;
                HierarchicalProperty lastModifiedProperty;
                GenericResource resource;
                if (version != null) {
                    VersionedFileResource versionedFile = new VersionedFileResource(uri, node, nsContext);
                    resource = versionedFile.getVersionHistory().getVersion(version);
                    lastModifiedProperty = resource.getProperty(FileResource.CREATIONDATE);
                    istream = ((VersionResource)resource).getContentAsStream();
                } else {
                    resource = new FileResource(uri, node, nsContext);
                    lastModifiedProperty = resource.getProperty(FileResource.GETLASTMODIFIED);
                    istream = ((FileResource)resource).getContentAsStream();
                }
                if (ifModifiedSince != null) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
                    Date lastModifiedDate = dateFormat.parse(lastModifiedProperty.getValue());
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
                    Date ifModifiedSinceDate = dateFormat.parse(ifModifiedSince);
                    if (ifModifiedSinceDate.getTime() >= lastModifiedDate.getTime()) {
                        return Response.Builder.notModified().build();
                    }
                }
                HierarchicalProperty contentLengthProperty = resource.getProperty(FileResource.GETCONTENTLENGTH);
                long contentLength = new Long(contentLengthProperty.getValue());
                HierarchicalProperty mimeTypeProperty = resource.getProperty(FileResource.GETCONTENTTYPE);
                String contentType = mimeTypeProperty.getValue();
                if (contentLength == 0L) {
                    return Response.Builder.ok().header("Accept-Ranges", "bytes").header("Cache-Control", this.generateCacheControl(cacheControls, contentType)).entity((Object)istream, contentType).build();
                }
                if (ranges.size() == 0) {
                    return Response.Builder.ok().header("Content-Length", Long.toString(contentLength)).header("Accept-Ranges", "bytes").header("Cache-Control", this.generateCacheControl(cacheControls, contentType)).entity((Object)istream, contentType).build();
                }
                if (ranges.size() == 1) {
                    Range range = ranges.get(0);
                    if (!this.validateRange(range, contentLength)) {
                        return Response.Builder.withStatus((int)416).header("Content-Range", "bytes */" + contentLength).build();
                    }
                    long start = range.getStart();
                    long end = range.getEnd();
                    long returnedContentLength = end - start + 1L;
                    RangedInputStream rangedInputStream = new RangedInputStream(istream, start, end);
                    return Response.Builder.withStatus((int)206).header("Content-Length", Long.toString(returnedContentLength)).header("Accept-Ranges", "bytes").header("Content-Range", "bytes " + start + "-" + end + "/" + contentLength).entity((Object)rangedInputStream, contentType).build();
                }
                for (int i = 0; i < ranges.size(); ++i) {
                    Range range = ranges.get(i);
                    if (!this.validateRange(range, contentLength)) {
                        return Response.Builder.withStatus((int)416).header("Content-Range", "bytes */" + contentLength).build();
                    }
                    ranges.set(i, range);
                }
                MultipartByterangesEntity mByterangesEntity = new MultipartByterangesEntity(resource, ranges, contentType, contentLength);
                return Response.Builder.withStatus((int)206).header("Accept-Ranges", "bytes").entity((Object)mByterangesEntity, "multipart/byteranges; boundary=1234567890").transformer((OutputEntityTransformer)new SerializableTransformer()).build();
            }
            CollectionResource resource = new CollectionResource(uri, node, nsContext);
            InputStream istream = resource.getContentAsStream(baseURI);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            TRAXTemplatesService templateService = (TRAXTemplatesService)container.getComponentInstanceOfType(TRAXTemplatesServiceImpl.class);
            HashMap<String, String> tp = new HashMap<String, String>();
            tp.put("xslt.template", "get.method.template");
            XSLT4SourceOutputTransformer transformer = new XSLT4SourceOutputTransformer(templateService);
            return Response.Builder.ok().entity((Object)new StreamSource(istream), "text/html").transformer((OutputEntityTransformer)transformer).setTransformerParameters(tp).build();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
            return Response.Builder.notFound().errorMessage(e.getMessage()).build();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    private boolean validateRange(Range range, long contentLength) {
        long start = range.getStart();
        long end = range.getEnd();
        if (start < 0L && end == -1L) {
            if (-1L * start >= contentLength) {
                start = 0L;
                end = contentLength - 1L;
            } else {
                start = contentLength + start;
                end = contentLength - 1L;
            }
        }
        if (start >= 0L && end == -1L) {
            end = contentLength - 1L;
        }
        if (end >= contentLength) {
            end = contentLength - 1L;
        }
        if (start >= 0L && end >= 0L && start <= end) {
            range.setStart(start);
            range.setEnd(end);
            return true;
        }
        return false;
    }

    private String generateCacheControl(HashMap<MediaType, String> cacheControlMap, String contentType) {
        ArrayList<MediaType> mediaTypesList = new ArrayList<MediaType>(cacheControlMap.keySet());
        Collections.sort(mediaTypesList, MediaTypeHelper.MEDIA_TYPE_COMPARATOR);
        String cacheControlValue = "no-cache";
        if (contentType == null || contentType.equals("")) {
            return cacheControlValue;
        }
        for (MediaType mediaType : mediaTypesList) {
            if (contentType.equals("*/*")) {
                cacheControlValue = cacheControlMap.get("*");
                break;
            }
            if (!mediaType.isCompatible(new MediaType(contentType.split("/")[0], contentType.split("/")[1]))) continue;
            cacheControlValue = cacheControlMap.get(mediaType);
            break;
        }
        return cacheControlValue;
    }
}

