/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.command.dasl.SearchRequestEntity;
import org.exoplatform.services.jcr.webdav.command.dasl.SearchResultResponseEntity;
import org.exoplatform.services.jcr.webdav.command.dasl.UnsupportedQueryException;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.rest.Response;

public class SearchCommand {
    public Response search(Session session, HierarchicalProperty body, String baseURI) {
        try {
            SearchRequestEntity requestEntity = new SearchRequestEntity(body);
            Query query = session.getWorkspace().getQueryManager().createQuery(requestEntity.getQuery(), requestEntity.getQueryLanguage());
            QueryResult queryResult = query.execute();
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            SearchResultResponseEntity searchResult = new SearchResultResponseEntity(queryResult, nsContext, baseURI);
            return Response.Builder.withStatus((int)207).entity((Object)searchResult).build();
        }
        catch (PathNotFoundException e) {
            return Response.Builder.notFound().errorMessage(e.getMessage()).build();
        }
        catch (UnsupportedQueryException e) {
            return Response.Builder.badRequest().errorMessage(e.getMessage()).build();
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }
}

