/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.rest.Response;

public class CheckInCommand {
    public Response checkIn(Session session, String path) {
        try {
            Node node = session.getRootNode().getNode(TextUtil.relativizePath(path));
            node.checkin();
            return Response.Builder.ok().build();
        }
        catch (UnsupportedRepositoryOperationException e) {
            return Response.Builder.withStatus((int)409).build();
        }
        catch (LockException exc) {
            return Response.Builder.withStatus((int)423).build();
        }
        catch (PathNotFoundException exc) {
            return Response.Builder.notFound().build();
        }
        catch (RepositoryException exc) {
            return Response.Builder.serverError().build();
        }
    }
}

