/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CheckOutCommand {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.webdav.CheckOutCommand");

    public Response checkout(Session session, String path) {
        try {
            Node node = session.getRootNode().getNode(TextUtil.relativizePath(path));
            node.checkout();
            return Response.ok().header("Cache-Control", (Object)"no-cache").build();
        }
        catch (UnsupportedRepositoryOperationException exc) {
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }
}

