/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;

public class NodeTypeUtil {
    public static String getNodeType(String nodeTypeHeader, String defaultNodeType, Set<String> allowedNodeTypes) throws NoSuchNodeTypeException {
        if (nodeTypeHeader == null) {
            return defaultNodeType;
        }
        if (allowedNodeTypes.contains(nodeTypeHeader)) {
            return nodeTypeHeader;
        }
        throw new NoSuchNodeTypeException("Unsupported node type: " + nodeTypeHeader);
    }

    public static String getContentNodeType(String contentNodeTypeHeader) {
        if (contentNodeTypeHeader != null) {
            return contentNodeTypeHeader;
        }
        return "nt:resource";
    }

    public static void checkContentResourceType(NodeType contentNodeType) throws NoSuchNodeTypeException {
        if (!contentNodeType.isNodeType("nt:resource")) {
            throw new NoSuchNodeTypeException("Content-Node type " + contentNodeType.getName() + " must extend nt:resource.");
        }
    }

    public static ArrayList<String> getMixinTypes(String mixinTypes) {
        return mixinTypes == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(mixinTypes.split(",")));
    }
}

