/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.ws.rs.core.MultivaluedMap;
import junit.framework.TestCase;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.webdav.MockHttpServletRequest;
import org.exoplatform.services.jcr.webdav.WebDavServiceImpl;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.ContainerRequest;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.InputHeadersMap;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.tools.DummyContainerResponseWriter;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public abstract class BaseStandaloneTest
extends TestCase {
    protected static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.BaseStandaloneTest");
    protected static String TEMP_PATH = "./temp/fsroot";
    protected static String WORKSPACE = "ws";
    public static final String DEST_WORKSPACE = "ws1";
    public static final String WORKSPACE2 = "ws2";
    protected SessionImpl session;
    protected SessionImpl destSession;
    protected SessionImpl session2;
    protected RepositoryImpl repository;
    protected CredentialsImpl credentials;
    protected Workspace workspace;
    protected RepositoryService repositoryService;
    protected Node root;
    protected StandaloneContainer container;
    protected ProviderBinder providers;
    protected ResourceBinder resourceBinder;
    protected RequestHandlerImpl requestHandler;
    public String defaultFileNodeType = "nt:file";
    public String defaultFolderNodeType = "nt:folder";
    public String repoName;

    public void setUp() throws Exception {
        String containerConf = ((Object)((Object)this)).getClass().getResource("/conf/standalone/test-configuration.xml").toString();
        String loginConf = BaseStandaloneTest.class.getResource("/login.conf").toString();
        StandaloneContainer.addConfigurationURL((String)containerConf);
        this.container = StandaloneContainer.getInstance();
        if (System.getProperty("java.security.auth.login.config") == null) {
            System.setProperty("java.security.auth.login.config", loginConf);
        }
        this.credentials = new CredentialsImpl("root", "exo".toCharArray());
        this.repositoryService = (RepositoryService)this.container.getComponentInstanceOfType(RepositoryService.class);
        this.repository = (RepositoryImpl)this.repositoryService.getDefaultRepository();
        this.repoName = this.repository.getName();
        this.session = (SessionImpl)this.repository.login((Credentials)this.credentials, WORKSPACE);
        this.destSession = (SessionImpl)this.repository.login((Credentials)this.credentials, DEST_WORKSPACE);
        this.session2 = (SessionImpl)this.repository.login((Credentials)this.credentials, WORKSPACE2);
        this.workspace = this.session.getWorkspace();
        this.initRepository();
        SessionProviderService sessionProviderService = (SessionProviderService)this.container.getComponentInstanceOfType(SessionProviderService.class);
        BaseStandaloneTest.assertNotNull((Object)sessionProviderService);
        sessionProviderService.setSessionProvider(null, new SessionProvider(new ConversationState(new Identity("admin"))));
        WebDavServiceImpl webDavServiceImpl = (WebDavServiceImpl)this.container.getComponentInstanceOfType(WebDavServiceImpl.class);
        BaseStandaloneTest.assertNotNull((Object)webDavServiceImpl);
        this.resourceBinder = (ResourceBinder)this.container.getComponentInstanceOfType(ResourceBinder.class);
        BaseStandaloneTest.assertNotNull((Object)this.resourceBinder);
        this.requestHandler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        BaseStandaloneTest.assertNotNull((Object)this.requestHandler);
        this.providers = ProviderBinder.getInstance();
        ApplicationContextImpl.setCurrent((ApplicationContext)new ApplicationContextImpl(null, null, this.providers));
        this.root = this.session.getRootNode().addNode("webdav-test");
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, MultivaluedMap<String, String> headers, byte[] data, ContainerResponseWriter writer) throws Exception {
        if (headers == null) {
            headers = new MultivaluedMapImpl();
        }
        ByteArrayInputStream in = null;
        if (data != null) {
            in = new ByteArrayInputStream(data);
        }
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(in, in != null ? in.available() : 0, method, (MultivaluedMap<String, String>)new InputHeadersMap((Map)headers));
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        EnvironmentContext.setCurrent((EnvironmentContext)envctx);
        ContainerRequest request = new ContainerRequest(method, new URI(requestURI), new URI(baseURI), (InputStream)in, (MultivaluedMap)new InputHeadersMap((Map)headers));
        ContainerResponse response = new ContainerResponse(writer);
        this.requestHandler.handleRequest((GenericContainerRequest)request, (GenericContainerResponse)response);
        return response;
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, MultivaluedMap<String, String> headers, byte[] data) throws Exception {
        return this.service(method, requestURI, baseURI, headers, data, (ContainerResponseWriter)new DummyContainerResponseWriter());
    }

    public ContainerResponse serviceWithEscape(String method, String requestURI, String baseURI, MultivaluedMap<String, String> headers, byte[] data) throws Exception {
        return this.service(method, this.escape(requestURI), baseURI, headers, data, (ContainerResponseWriter)new DummyContainerResponseWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        this.root.remove();
        if (this.session != null) {
            try {
                this.session.refresh(false);
                Node rootNode = this.session.getRootNode();
                if (rootNode.hasNodes()) {
                    NodeIterator children = rootNode.getNodes();
                    while (children.hasNext()) {
                        Node node = children.nextNode();
                        if (node.getPath().startsWith("/jcr:system")) continue;
                        node.remove();
                    }
                    this.session.save();
                }
            }
            catch (Exception e) {
                log.error((Object)("tearDown() ERROR " + ((Object)((Object)this)).getClass().getName() + "." + this.getName() + " " + e), (Throwable)e);
            }
            finally {
                this.session.logout();
            }
        }
        super.tearDown();
    }

    protected abstract String getRepositoryName();

    public void initRepository() throws RepositoryException {
    }

    public String getPathWS() {
        return "/jcr/" + this.repoName + "/" + WORKSPACE;
    }

    public String getFakePathWS() {
        return "/jcr/fake-repo-name/" + WORKSPACE;
    }

    public String getPathDestWS() {
        return "/jcr/" + this.repoName + "/ws1";
    }

    public String escape(String path) {
        return TextUtil.escape((String)path, (char)'%', (boolean)true);
    }
}

