/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.command.proppatch.PropPatchResponseEntity;
import org.exoplatform.services.rest.impl.ContainerResponse;

public class TestPropPatch
extends BaseStandaloneTest {
    private final String author = "eXoPlatform";
    private final String authorProp = "webdav:Author";
    private final String nt_webdave_file = "webdav:file";
    private final String patch = "<?xml version=\"1.0\"?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:b=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\" xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\"><D:set><D:prop><webdav:Author>eXoPlatform</webdav:Author></D:prop></D:set></D:propertyupdate>";

    @Override
    protected String getRepositoryName() {
        return null;
    }

    public void testPropPatchSetWithLock2() throws Exception {
        this.testPropPatchSetWithLock2(this.getPathWS());
    }

    public void testPropPatchSetWithLock2WithFakePathWS() throws Exception {
        this.testPropPatchSetWithLock2(this.getFakePathWS());
    }

    private void testPropPatchSetWithLock2(String pathWs) throws Exception {
        Object fileName = "testPropPatchFile";
        this.session.getRootNode().addNode((String)fileName);
        Node node = this.session.getRootNode().addNode((String)fileName, "webdav:file");
        node.setProperty("webdav:Author", "eXoPlatform");
        node.addNode("jcr:content", "nt:resource");
        Node content = node.getNode("jcr:content");
        content.setProperty("jcr:mimeType", "text/xml");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", "data");
        node.addMixin("mix:lockable");
        this.session.save();
        node.lock(true, true);
        this.session.save();
        fileName = (String)fileName + "[2]";
        ContainerResponse response = this.serviceWithEscape("PROPPATCH", pathWs + "/" + (String)fileName, "", null, "<?xml version=\"1.0\"?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:b=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\" xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\"><D:set><D:prop><webdav:Author>eXoPlatform</webdav:Author></D:prop></D:set></D:propertyupdate>".getBytes());
        PropPatchResponseEntity entity = (PropPatchResponseEntity)response.getEntity();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outputStream);
        String resp = outputStream.toString();
        TestPropPatch.assertNotNull((Object)resp);
        Property p = node.getProperty("webdav:Author");
        String str = p.getString();
        TestPropPatch.assertNotNull((Object)str);
    }

    public void testPropPatchWithNonLatin() throws Exception {
        String encodedfileName = "%e3%81%82%e3%81%84%e3%81%86%e3%81%88%e3%81%8a";
        String decodedfileName = URLDecoder.decode(encodedfileName, "UTF-8");
        Node node = this.session.getRootNode().addNode(decodedfileName, "webdav:file");
        node.setProperty("webdav:Author", "eXoPlatform");
        node.addNode("jcr:content", "nt:resource");
        Node content = node.getNode("jcr:content");
        content.setProperty("jcr:mimeType", "text/xml");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", "data");
        node.addMixin("mix:lockable");
        this.session.save();
        node.lock(true, true);
        this.session.save();
        ContainerResponse response = this.service("PROPPATCH", this.getPathWS() + "/" + encodedfileName, "", null, "<?xml version=\"1.0\"?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:b=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\" xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\"><D:set><D:prop><webdav:Author>eXoPlatform</webdav:Author></D:prop></D:set></D:propertyupdate>".getBytes());
        PropPatchResponseEntity entity = (PropPatchResponseEntity)response.getEntity();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outputStream);
        String resp = outputStream.toString();
        TestPropPatch.assertTrue((boolean)resp.contains(encodedfileName));
        TestPropPatch.assertFalse((boolean)resp.contains(decodedfileName));
    }
}

