/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.ByteArrayInputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestCopy
extends BaseStandaloneTest {
    private static final String host = "http://localhost:8080";

    public void testCopyForNonCollectionSingleWorkSpace() throws Exception {
        this.testCopyForNonCollectionSingleWorkSpace(this.getPathWS());
    }

    public void testCopyForNonCollectionSingleWorkSpaceWithFakePathWS() throws Exception {
        this.testCopyForNonCollectionSingleWorkSpace(this.getFakePathWS());
    }

    private void testCopyForNonCollectionSingleWorkSpace(String pathWs) throws Exception {
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + pathWs + destFilename));
        ContainerResponse response = this.serviceWithEscape("COPY", pathWs + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)201, (int)response.getStatus());
        TestCopy.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)destFilename)));
        Node nodeDest = this.session.getRootNode().getNode(TextUtil.relativizePath((String)destFilename));
        TestCopy.assertTrue((boolean)nodeDest.hasNode("jcr:content"));
        Node nodeDestContent = nodeDest.getNode("jcr:content");
        TestCopy.assertTrue((boolean)nodeDestContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamDest = (ByteArrayInputStream)nodeDestContent.getProperty("jcr:data").getStream();
        String getContentDest = TestUtils.stream2string(streamDest, null);
        TestCopy.assertEquals((String)content, (String)getContentDest);
        TestCopy.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)filename)));
        Node nodeBase = this.session.getRootNode().getNode(TextUtil.relativizePath((String)filename));
        TestCopy.assertTrue((boolean)nodeBase.hasNode("jcr:content"));
        Node nodeBaseContent = nodeBase.getNode("jcr:content");
        TestCopy.assertTrue((boolean)nodeBaseContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamBase = (ByteArrayInputStream)nodeBaseContent.getProperty("jcr:data").getStream();
        String getContentBase = TestUtils.stream2string(streamBase, null);
        TestCopy.assertEquals((String)content, (String)getContentBase);
    }

    public void testeCopyForNonCollectionDiferentWorkSpaces() throws Exception {
        TestCopy.assertNotSame((Object)this.session.getWorkspace().getName(), (Object)this.destSession.getWorkspace().getName());
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathDestWS() + destFilename));
        ContainerResponse response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)201, (int)response.getStatus());
        TestCopy.assertTrue((boolean)this.destSession.getRootNode().hasNode(TextUtil.relativizePath((String)destFilename)));
        Node nodeDest = this.destSession.getRootNode().getNode(TextUtil.relativizePath((String)destFilename));
        TestCopy.assertTrue((boolean)nodeDest.hasNode("jcr:content"));
        Node nodeDestContent = nodeDest.getNode("jcr:content");
        nodeDestContent.hasProperty("jcr:data");
        ByteArrayInputStream streamDest = (ByteArrayInputStream)nodeDestContent.getProperty("jcr:data").getStream();
        String getContentDest = TestUtils.stream2string(streamDest, null);
        TestCopy.assertEquals((String)content, (String)getContentDest);
        TestCopy.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)filename)));
        Node nodeBase = this.session.getRootNode().getNode(TextUtil.relativizePath((String)filename));
        TestCopy.assertTrue((boolean)nodeBase.hasNode("jcr:content"));
        Node nodeBaseContent = nodeBase.getNode("jcr:content");
        TestCopy.assertTrue((boolean)nodeBaseContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamBase = (ByteArrayInputStream)nodeBaseContent.getProperty("jcr:data").getStream();
        String getContentBase = TestUtils.stream2string(streamBase, null);
        TestCopy.assertEquals((String)content, (String)getContentBase);
    }

    public void testLocationHeaderInCopyResponse() throws Exception {
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathWS() + destFilename));
        ContainerResponse response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)201, (int)response.getStatus());
        TestCopy.assertTrue((boolean)response.getHttpHeaders().containsKey((Object)"Location"));
        TestCopy.assertEquals((String)(host + this.getPathWS() + destFilename), (String)response.getHttpHeaders().getFirst((Object)"Location").toString());
    }

    public void testDestinationHeaderParsing() throws Exception {
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName() + " test";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathWS() + destFilename));
        ContainerResponse response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)201, (int)response.getStatus());
        filename = destFilename;
        destFilename = TestUtils.getFileName() + " 'test";
        headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathWS() + destFilename));
        response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)201, (int)response.getStatus());
    }

    public void testNoContentResponses() throws Exception {
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, destFilename, inputStream, this.defaultFileNodeType, "");
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathWS() + destFilename));
        headers.add((Object)"Overwrite", (Object)"T");
        ContainerResponse response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)204, (int)response.getStatus());
    }

    public void testHttpsSchemeInDestinationHeaderParsing() throws Exception {
        String httpsHost = "https://localhost:8080";
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(httpsHost + this.getPathWS() + destFilename));
        ContainerResponse response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)201, (int)response.getStatus());
    }

    public void testCopyDestinationHeaderBeginsFromWorkspaceName() throws Exception {
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(WORKSPACE + destFilename));
        ContainerResponse response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)201, (int)response.getStatus());
        TestCopy.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)destFilename)));
        Node nodeDest = this.session.getRootNode().getNode(TextUtil.relativizePath((String)destFilename));
        TestCopy.assertTrue((boolean)nodeDest.hasNode("jcr:content"));
        Node nodeDestContent = nodeDest.getNode("jcr:content");
        TestCopy.assertTrue((boolean)nodeDestContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamDest = (ByteArrayInputStream)nodeDestContent.getProperty("jcr:data").getStream();
        String getContentDest = TestUtils.stream2string(streamDest, null);
        TestCopy.assertEquals((String)content, (String)getContentDest);
        TestCopy.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)filename)));
        Node nodeBase = this.session.getRootNode().getNode(TextUtil.relativizePath((String)filename));
        TestCopy.assertTrue((boolean)nodeBase.hasNode("jcr:content"));
        Node nodeBaseContent = nodeBase.getNode("jcr:content");
        TestCopy.assertTrue((boolean)nodeBaseContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamBase = (ByteArrayInputStream)nodeBaseContent.getProperty("jcr:data").getStream();
        String getContentBase = TestUtils.stream2string(streamBase, null);
        TestCopy.assertEquals((String)content, (String)getContentBase);
    }

    public void testCopyToFolderWithSpace() throws Exception {
        String folderNameWithSpace = "new folder - testCopyToFolderWithSpace";
        this.session.getRootNode().addNode(folderNameWithSpace, "nt:folder");
        this.session.save();
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = "/" + folderNameWithSpace + TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(WORKSPACE + destFilename));
        ContainerResponse response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)201, (int)response.getStatus());
        TestCopy.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)destFilename)));
        Node nodeDest = this.session.getRootNode().getNode(TextUtil.relativizePath((String)destFilename));
        TestCopy.assertTrue((boolean)nodeDest.hasNode("jcr:content"));
        Node nodeDestContent = nodeDest.getNode("jcr:content");
        TestCopy.assertTrue((boolean)nodeDestContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamDest = (ByteArrayInputStream)nodeDestContent.getProperty("jcr:data").getStream();
        String getContentDest = TestUtils.stream2string(streamDest, null);
        TestCopy.assertEquals((String)content, (String)getContentDest);
        TestCopy.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)filename)));
        Node nodeBase = this.session.getRootNode().getNode(TextUtil.relativizePath((String)filename));
        TestCopy.assertTrue((boolean)nodeBase.hasNode("jcr:content"));
        Node nodeBaseContent = nodeBase.getNode("jcr:content");
        TestCopy.assertTrue((boolean)nodeBaseContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamBase = (ByteArrayInputStream)nodeBaseContent.getProperty("jcr:data").getStream();
        String getContentBase = TestUtils.stream2string(streamBase, null);
        TestCopy.assertEquals((String)content, (String)getContentBase);
    }

    public void testCopyToFolderWithSpaceUnescapedChars() throws Exception {
        String folderNameWithSpace = "new folder - testCopyToFolderWithSpaceUnescapedChars";
        this.session.getRootNode().addNode(folderNameWithSpace, "nt:folder");
        this.session.save();
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TextUtil.unescape((String)("/" + folderNameWithSpace + TestUtils.getFileName()), (char)'%');
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(WORKSPACE + destFilename));
        ContainerResponse response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)201, (int)response.getStatus());
        TestCopy.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)destFilename)));
        Node nodeDest = this.session.getRootNode().getNode(TextUtil.relativizePath((String)destFilename));
        TestCopy.assertTrue((boolean)nodeDest.hasNode("jcr:content"));
        Node nodeDestContent = nodeDest.getNode("jcr:content");
        TestCopy.assertTrue((boolean)nodeDestContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamDest = (ByteArrayInputStream)nodeDestContent.getProperty("jcr:data").getStream();
        String getContentDest = TestUtils.stream2string(streamDest, null);
        TestCopy.assertEquals((String)content, (String)getContentDest);
        TestCopy.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)filename)));
        Node nodeBase = this.session.getRootNode().getNode(TextUtil.relativizePath((String)filename));
        TestCopy.assertTrue((boolean)nodeBase.hasNode("jcr:content"));
        Node nodeBaseContent = nodeBase.getNode("jcr:content");
        TestCopy.assertTrue((boolean)nodeBaseContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamBase = (ByteArrayInputStream)nodeBaseContent.getProperty("jcr:data").getStream();
        String getContentBase = TestUtils.stream2string(streamBase, null);
        TestCopy.assertEquals((String)content, (String)getContentBase);
    }

    public void testCopyResourceToNonExistingWorkspace() throws Exception {
        String folderName = "new folder";
        this.session.getRootNode().addNode(folderName, "nt:folder");
        this.session.save();
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TextUtil.unescape((String)("/" + folderName + TestUtils.getFileName()), (char)'%');
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(WORKSPACE + "_" + destFilename));
        ContainerResponse response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)409, (int)response.getStatus());
        headers.add((Object)"Overwrite", (Object)"T");
        response = this.serviceWithEscape("COPY", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)409, (int)response.getStatus());
        this.session.getRootNode().getNode(folderName).remove();
    }

    public void testCopyCollectionToNonExistingWorkspace() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(WORKSPACE + "_/test"));
        ContainerResponse response = this.service("COPY", this.getPathWS() + TestUtils.getFolderName(), host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)409, (int)response.getStatus());
        headers.add((Object)"Overwrite", (Object)"T");
        response = this.service("COPY", this.getPathWS() + TestUtils.getFolderName(), host, (MultivaluedMap<String, String>)headers, null);
        TestCopy.assertEquals((int)409, (int)response.getStatus());
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

