/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestPut
extends BaseStandaloneTest {
    public void testPut() throws Exception {
        this.testPut(this.getPathWS());
    }

    public void testPutWithFakePathWS() throws Exception {
        this.testPut(this.getFakePathWS());
    }

    private void testPut(String pathWs) throws Exception {
        String content = TestUtils.getFileContent();
        Object path = TestUtils.getFileName();
        ContainerResponse containerResponse = this.service("PUT", pathWs + (String)path, "", null, content.getBytes());
        TestPut.assertEquals((int)201, (int)containerResponse.getStatus());
        TestPut.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)path)));
        path = (String)path + "[2]";
        containerResponse = this.serviceWithEscape("PUT", this.getPathWS() + (String)path, "", null, content.getBytes());
        TestPut.assertEquals((int)201, (int)containerResponse.getStatus());
        TestPut.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)path)));
    }

    public void testPutNotFound() throws Exception {
        String content = TestUtils.getFileContent();
        String path = TestUtils.getFileName();
        ContainerResponse containerResponse = this.service("PUT", this.getPathWS() + "/not-found" + path, "", null, content.getBytes());
        TestPut.assertEquals((int)409, (int)containerResponse.getStatus());
    }

    public void testPutToNonExistingWorkspace() throws Exception {
        String content = TestUtils.getFileContent();
        String path = TestUtils.getFileName();
        ContainerResponse containerResponse = this.service("PUT", this.getPathWS() + "_" + path, "", null, content.getBytes());
        TestPut.assertEquals((int)409, (int)containerResponse.getStatus());
    }

    public void testPutFileNodeTypeHeader() throws Exception {
        String content = TestUtils.getFileContent();
        ContainerResponse containerResponse = this.service("PUT", this.getPathWS() + TestUtils.getFileName(), "", null, content.getBytes());
        TestPut.assertEquals((int)201, (int)containerResponse.getStatus());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"File-NodeType", (Object)"nt:folder");
        containerResponse = this.service("PUT", this.getPathWS() + TestUtils.getFileName(), "", (MultivaluedMap<String, String>)headers, content.getBytes());
        TestPut.assertEquals((int)400, (int)containerResponse.getStatus());
        String fileName = TestUtils.getFileName();
        headers = new MultivaluedMapImpl();
        headers.add((Object)"File-NodeType", (Object)"nt:file");
        containerResponse = this.service("PUT", this.getPathWS() + fileName, "", (MultivaluedMap<String, String>)headers, content.getBytes());
        TestPut.assertEquals((int)201, (int)containerResponse.getStatus());
        TestPut.assertEquals((String)"nt:file", (String)TestUtils.getFileNodeType((Session)this.session, fileName));
    }

    public void testPutContentTypeHeader() throws Exception {
        String content = TestUtils.getFileContent();
        String fileName = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-NodeType", (Object)"webdav:goodres");
        ContainerResponse containerResponse = this.service("PUT", this.getPathWS() + fileName, "", (MultivaluedMap<String, String>)headers, content.getBytes());
        TestPut.assertEquals((int)201, (int)containerResponse.getStatus());
        TestPut.assertEquals((String)"webdav:goodres", (String)TestUtils.getContentNodeType((Session)this.session, fileName));
        headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-NodeType", (Object)"webdav:badres");
        containerResponse = this.service("PUT", this.getPathWS() + TestUtils.getFileName(), "", (MultivaluedMap<String, String>)headers, content.getBytes());
        TestPut.assertEquals((int)400, (int)containerResponse.getStatus());
    }

    public void testPutMixinsHeader() throws Exception {
        String content = TestUtils.getFileContent();
        String fileName = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-NodeType", (Object)"webdav:goodres");
        headers.add((Object)"Content-MixinTypes", (Object)"mix:wdTestMixin1,mix:wdTestMixin2");
        ContainerResponse containerResponse = this.service("PUT", this.getPathWS() + fileName, "", (MultivaluedMap<String, String>)headers, content.getBytes());
        TestPut.assertEquals((int)201, (int)containerResponse.getStatus());
        NodeType[] mixins = TestUtils.getContentMixins((Session)this.session, fileName);
        TestPut.assertEquals((int)2, (int)mixins.length);
        for (NodeType mixin : mixins) {
            TestPut.assertTrue((mixin.getName().equals("mix:wdTestMixin1") || mixin.getName().equals("mix:wdTestMixin2") ? 1 : 0) != 0);
        }
    }

    public void testMimeType() throws Exception {
        String content = TestUtils.getFileContent();
        String path = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"text/xml");
        ContainerResponse containerResponse = this.service("PUT", this.getPathWS() + path, "", (MultivaluedMap<String, String>)headers, content.getBytes());
        TestPut.assertEquals((int)201, (int)containerResponse.getStatus());
        TestPut.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)path)));
        Node node = this.session.getRootNode().getNode(TextUtil.relativizePath((String)path));
        TestPut.assertTrue((boolean)node.hasNode("jcr:content"));
        Node node2 = node.getNode("jcr:content");
        TestPut.assertTrue((boolean)node2.hasProperty("jcr:mimeType"));
        PropertyImpl property = (PropertyImpl)node2.getProperty("jcr:mimeType");
        TestPut.assertEquals((String)((String)headers.getFirst((Object)"Content-Type")), (String)property.getString());
    }

    public void testLocationHeaderInPutResponse() throws Exception {
        String content = TestUtils.getFileContent();
        String filename = TestUtils.getFileName();
        ContainerResponse containerResponse = this.service("PUT", this.getPathWS() + filename, "", null, content.getBytes());
        TestPut.assertEquals((int)201, (int)containerResponse.getStatus());
        TestPut.assertTrue((boolean)containerResponse.getHttpHeaders().containsKey((Object)"Location"));
        TestPut.assertEquals((String)(this.getPathWS() + filename), (String)containerResponse.getHttpHeaders().getFirst((Object)"Location").toString());
    }

    public void testUntrustedUserAgentResourceCreation() throws Exception {
        String content = TestUtils.getFileContent();
        String path = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"application/octet-stream");
        headers.add((Object)"User-Agent", (Object)"test-user-agent");
        this.service("PUT", this.getPathWS() + path, "", (MultivaluedMap<String, String>)headers, content.getBytes());
        Node node = this.session.getRootNode().getNode(TextUtil.relativizePath((String)path)).getNode("jcr:content");
        TestPut.assertEquals((String)"text/plain", (String)node.getProperty("jcr:mimeType").getString());
    }

    public void testUntrustedUserAgentResourceModification() throws Exception {
        String content = TestUtils.getFileContent();
        String path = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"text/plain");
        this.service("PUT", this.getPathWS() + path, "", (MultivaluedMap<String, String>)headers, content.getBytes());
        headers.clear();
        content = TestUtils.getFileContent();
        headers.add((Object)"User-Agent", (Object)"test-user-agent");
        headers.add((Object)"Content-Type", (Object)"application/octet-stream");
        this.service("PUT", this.getPathWS() + path, "", (MultivaluedMap<String, String>)headers, content.getBytes());
        Node node = this.session.getRootNode().getNode(TextUtil.relativizePath((String)path)).getNode("jcr:content");
        TestPut.assertEquals((String)"text/plain", (String)node.getProperty("jcr:mimeType").getString());
    }

    public void testTrustedUserAgentResourceModification() throws Exception {
        String content = TestUtils.getFileContent();
        String path = TestUtils.getFileName() + ".html";
        this.service("PUT", this.getPathWS() + path, "", null, content.getBytes());
        Node node = this.session.getRootNode().getNode(TextUtil.relativizePath((String)path));
        TestPut.assertEquals((String)"text/html", (String)node.getNode("jcr:content").getProperty("jcr:mimeType").getString());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"text/xml");
        this.service("PUT", this.getPathWS() + path, "", (MultivaluedMap<String, String>)headers, content.getBytes());
        TestPut.assertEquals((String)"text/xml", (String)node.getNode("jcr:content").getProperty("jcr:mimeType").getString());
    }

    public void testMimeTypeDefinedCorrectIfNoExtensionSet() throws Exception {
        String filename = IdGenerator.generate();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"text/html");
        ContainerResponse containerResponse = this.service("PUT", this.getPathWS() + "/" + filename, "", (MultivaluedMap<String, String>)headers, "".getBytes());
        TestPut.assertEquals((int)201, (int)containerResponse.getStatus());
        headers.clear();
        containerResponse = this.service("PUT", this.getPathWS() + "/" + filename, "", (MultivaluedMap<String, String>)headers, IdGenerator.generate().getBytes());
        Node node = this.session.getRootNode().getNode(TextUtil.relativizePath((String)filename));
        TestPut.assertTrue((boolean)node.hasNode("jcr:content"));
        Node node2 = node.getNode("jcr:content");
        TestPut.assertTrue((boolean)node2.hasProperty("jcr:mimeType"));
        PropertyImpl property = (PropertyImpl)node2.getProperty("jcr:mimeType");
        TestPut.assertEquals((String)"text/html", (String)property.getString());
        containerResponse = this.service("GET", this.getPathWS() + "/" + filename, "", null, null);
        TestPut.assertEquals((Object)"text/html", (Object)containerResponse.getHttpHeaders().getFirst((Object)"Content-Type"));
    }

    public void testPutContentTypeHeaderWithEncoding() throws Exception {
        String content = TestUtils.getFileContent();
        String fileName = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"webdav:goodres; charset=test-char-set");
        ContainerResponse containerResponse = this.service("PUT", this.getPathWS() + fileName, "", (MultivaluedMap<String, String>)headers, content.getBytes());
        TestPut.assertEquals((int)201, (int)containerResponse.getStatus());
        TestPut.assertTrue((String)"Content node is expected to have 'jcr:encoding' property set during PUT method", (boolean)TestUtils.getContentNode((Session)this.session, fileName).hasProperty("jcr:encoding"));
        TestPut.assertEquals((String)"test-char-set", (String)TestUtils.getContentNode((Session)this.session, fileName).getProperty("jcr:encoding").getString());
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

