/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.ByteArrayInputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestMkCol
extends BaseStandaloneTest {
    public void testSimpleMkCol() throws Exception {
        String folder = TestUtils.getFolderName();
        ContainerResponse response = this.service("MKCOL", this.getPathWS() + folder, "", null, null);
        TestMkCol.assertEquals((int)201, (int)response.getStatus());
        response = this.serviceWithEscape("MKCOL", this.getPathWS() + folder + "[2]", "", null, null);
        TestMkCol.assertEquals((int)201, (int)response.getStatus());
    }

    public void testSimpleMkColWithFakePathWS() throws Exception {
        String folder = TestUtils.getFolderName();
        ContainerResponse response = this.service("MKCOL", this.getFakePathWS() + folder, "", null, null);
        TestMkCol.assertEquals((int)201, (int)response.getStatus());
    }

    public void testMkCol() throws Exception {
        String folder = TestUtils.getFolderName();
        ContainerResponse response = this.service("MKCOL", this.getPathWS() + folder, "", null, null);
        TestMkCol.assertEquals((int)201, (int)response.getStatus());
        String file = TestUtils.getFileName();
        String path = folder + file;
        String content = TestUtils.getFileContent();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, path, inputStream, this.defaultFileNodeType, "");
        TestMkCol.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)folder)));
        Node folderNode = this.session.getRootNode().getNode(TextUtil.relativizePath((String)folder));
        TestMkCol.assertTrue((boolean)folderNode.hasNode(TextUtil.relativizePath((String)file)));
    }

    public void testFolderNodeTypeHeader() throws Exception {
        String folder = TestUtils.getFolderName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Folder-NodeType", (Object)"nt:file");
        ContainerResponse response = this.service("MKCOL", this.getPathWS() + folder, "", (MultivaluedMap<String, String>)headers, null);
        TestMkCol.assertEquals((int)415, (int)response.getStatus());
        headers.clear();
        headers.add((Object)"File-NodeType", (Object)"nt:folder");
        response = this.service("MKCOL", this.getPathWS() + folder, "", (MultivaluedMap<String, String>)headers, null);
        TestMkCol.assertEquals((int)201, (int)response.getStatus());
    }

    public void testLocationHeaderInMkColResponse() throws Exception {
        String folder = TestUtils.getFolderName();
        ContainerResponse response = this.service("MKCOL", this.getPathWS() + folder, "", null, null);
        TestMkCol.assertEquals((int)201, (int)response.getStatus());
        TestMkCol.assertTrue((boolean)response.getHttpHeaders().containsKey((Object)"Location"));
        TestMkCol.assertEquals((String)(this.getPathWS() + folder), (String)response.getHttpHeaders().getFirst((Object)"Location").toString());
    }

    public void testMkColInNonExistingWorkspace() throws Exception {
        String folder = TestUtils.getFolderName();
        ContainerResponse response = this.service("MKCOL", this.getPathWS() + "_" + folder, "", null, null);
        TestMkCol.assertEquals((int)409, (int)response.getStatus());
    }

    public void testConflict() throws Exception {
        String folder = TestUtils.getFolderName();
        ContainerResponse response = this.service("MKCOL", this.getPathWS() + folder + folder, "", null, null);
        TestMkCol.assertEquals((int)409, (int)response.getStatus());
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

