/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.ext;

import java.io.FileInputStream;
import java.util.Arrays;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestEncoding
extends BaseStandaloneTest {
    public static final String CONTENT = "\u043f\u0440\u0438\u043a\u043b\u0430\u0434";
    public static final String UTF_FILE = "/utfFile.txt";
    public static final String UTF_CONTENT_TYPE = "text/plain";
    public static final String UTF_CHARSET = "UTF8";
    public static byte[] UTF_CONTENT;
    public static final String WIN_FILE = "/winFile.txt";
    public static final String WIN_CONTENT_TYPE = "text/plain";
    public static final String WIN_CHARSET = "Cp1251";
    public static byte[] WIN_CONTENT;
    public static final String ISO_FILE = "/isoFile.txt";
    public static final String ISO_CONTENT_TYPE = "text/plain";
    public static final String ISO_CHARSET = "ISO-8859-5";
    public static byte[] ISO_CONTENT;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        UTF_CONTENT = CONTENT.getBytes(UTF_CHARSET);
        WIN_CONTENT = CONTENT.getBytes(WIN_CHARSET);
        ISO_CONTENT = CONTENT.getBytes(ISO_CHARSET);
    }

    public void testNoContentTypeHeader() throws Exception {
        ContainerResponse response = this.service("PUT", this.getPathWS() + UTF_FILE, "", null, UTF_CONTENT);
        TestEncoding.assertEquals((int)201, (int)response.getStatus());
        response = this.service("GET", this.getPathWS() + UTF_FILE, "", null, null);
        TestEncoding.assertEquals((int)200, (int)response.getStatus());
        byte[] responseContent = TestUtils.stream2string((FileInputStream)response.getEntity(), UTF_CHARSET).getBytes();
        TestEncoding.assertTrue((boolean)Arrays.equals(UTF_CONTENT, responseContent));
        response = this.service("PUT", this.getPathWS() + WIN_FILE, "", null, WIN_CONTENT);
        TestEncoding.assertEquals((int)201, (int)response.getStatus());
        response = this.service("GET", this.getPathWS() + WIN_FILE, "", null, null);
        TestEncoding.assertEquals((int)200, (int)response.getStatus());
        responseContent = TestUtils.stream2string((FileInputStream)response.getEntity(), WIN_CHARSET).getBytes(WIN_CHARSET);
        TestEncoding.assertTrue((boolean)Arrays.equals(WIN_CONTENT, responseContent));
        response = this.service("PUT", this.getPathWS() + ISO_FILE, "", null, ISO_CONTENT);
        TestEncoding.assertEquals((int)201, (int)response.getStatus());
        response = this.service("GET", this.getPathWS() + ISO_FILE, "", null, null);
        TestEncoding.assertEquals((int)200, (int)response.getStatus());
        responseContent = TestUtils.stream2string((FileInputStream)response.getEntity(), ISO_CHARSET).getBytes(ISO_CHARSET);
        TestEncoding.assertTrue((boolean)Arrays.equals(ISO_CONTENT, responseContent));
    }

    public void testContentType() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"text/plain");
        ContainerResponse response = this.service("PUT", this.getPathWS() + UTF_FILE, "", (MultivaluedMap<String, String>)headers, UTF_CONTENT);
        TestEncoding.assertEquals((int)201, (int)response.getStatus());
        response = this.service("GET", this.getPathWS() + UTF_FILE, "", null, null);
        TestEncoding.assertEquals((int)200, (int)response.getStatus());
        byte[] responseContent = TestUtils.stream2string((FileInputStream)response.getEntity(), UTF_CHARSET).getBytes(UTF_CHARSET);
        TestEncoding.assertTrue((boolean)Arrays.equals(UTF_CONTENT, responseContent));
        TestEncoding.assertEquals((String)"text/plain", (String)response.getContentType().toString());
        headers.clear();
        headers.add((Object)"Content-Type", (Object)"text/plain");
        response = this.service("PUT", this.getPathWS() + WIN_FILE, "", (MultivaluedMap<String, String>)headers, WIN_CONTENT);
        TestEncoding.assertEquals((int)201, (int)response.getStatus());
        response = this.service("GET", this.getPathWS() + WIN_FILE, "", null, null);
        TestEncoding.assertEquals((int)200, (int)response.getStatus());
        responseContent = TestUtils.stream2string((FileInputStream)response.getEntity(), WIN_CHARSET).getBytes(WIN_CHARSET);
        TestEncoding.assertTrue((boolean)Arrays.equals(WIN_CONTENT, responseContent));
        TestEncoding.assertEquals((String)"text/plain", (String)response.getContentType().toString());
        headers.clear();
        headers.add((Object)"Content-Type", (Object)"text/plain");
        response = this.service("PUT", this.getPathWS() + ISO_FILE, "", (MultivaluedMap<String, String>)headers, ISO_CONTENT);
        TestEncoding.assertEquals((int)201, (int)response.getStatus());
        response = this.service("GET", this.getPathWS() + ISO_FILE, "", null, null);
        TestEncoding.assertEquals((int)200, (int)response.getStatus());
        responseContent = TestUtils.stream2string((FileInputStream)response.getEntity(), ISO_CHARSET).getBytes(ISO_CHARSET);
        TestEncoding.assertTrue((boolean)Arrays.equals(ISO_CONTENT, responseContent));
        TestEncoding.assertEquals((String)"text/plain", (String)response.getContentType().toString());
        headers.clear();
    }

    public void testRewriteEncodedFile() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"text/plain");
        ContainerResponse response = this.service("PUT", this.getPathWS() + ISO_FILE, "", (MultivaluedMap<String, String>)headers, ISO_CONTENT);
        TestEncoding.assertEquals((int)201, (int)response.getStatus());
        response = this.service("GET", this.getPathWS() + ISO_FILE, "", null, null);
        TestEncoding.assertEquals((int)200, (int)response.getStatus());
        byte[] responseContent = TestUtils.stream2string((FileInputStream)response.getEntity(), ISO_CHARSET).getBytes(ISO_CHARSET);
        TestEncoding.assertTrue((boolean)Arrays.equals(ISO_CONTENT, responseContent));
        TestEncoding.assertEquals((String)"text/plain", (String)response.getContentType().toString());
        headers.clear();
        headers.add((Object)"Content-Type", (Object)"text/plain");
        response = this.service("PUT", this.getPathWS() + ISO_FILE, "", (MultivaluedMap<String, String>)headers, WIN_CONTENT);
        TestEncoding.assertEquals((int)201, (int)response.getStatus());
        response = this.service("GET", this.getPathWS() + ISO_FILE, "", null, null);
        TestEncoding.assertEquals((int)200, (int)response.getStatus());
        responseContent = TestUtils.stream2string((FileInputStream)response.getEntity(), WIN_CHARSET).getBytes(WIN_CHARSET);
        TestEncoding.assertTrue((boolean)Arrays.equals(WIN_CONTENT, responseContent));
        TestEncoding.assertEquals((String)"text/plain", (String)response.getContentType().toString());
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

