/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.order;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.jcr.Node;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.WebDavConst;
import org.exoplatform.services.jcr.webdav.command.order.OrderPatchResponseEntity;
import org.exoplatform.services.jcr.webdav.command.order.OrderPatchTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.rest.ext.provider.HierarchicalPropertyEntityProvider;
import org.exoplatform.services.rest.impl.ContainerResponse;

public class TestOrderAfter
extends OrderPatchTest {
    protected Node orderAfterNode;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.session.refresh(false);
        if (this.orderAfterNode == null) {
            this.orderAfterNode = this.orderPatchNode.addNode("orderAfterNode", "nt:unstructured");
            this.session.save();
            for (int i = 1; i <= 5; ++i) {
                this.orderAfterNode.addNode("n" + i, "nt:unstructured");
            }
            this.session.save();
        }
    }

    public void testOrderAfter1() throws Exception {
        this.assertOrder(this.orderAfterNode, new String[]{"n1", "n2", "n3", "n4", "n5"});
        String path = this.orderAfterNode.getPath();
        String xml = "<D:orderpatch xmlns:D=\"DAV:\"><D:order-member><D:segment>n1</D:segment><D:position><D:after><D:segment>n3</D:segment></D:after></D:position></D:order-member></D:orderpatch>";
        ContainerResponse response = this.service("ORDERPATCH", this.getPathWS() + URLEncoder.encode(path, "UTF-8"), "", null, xml.getBytes());
        TestOrderAfter.assertEquals((int)200, (int)response.getStatus());
        this.assertOrder(this.orderAfterNode, new String[]{"n2", "n3", "n1", "n4", "n5"});
    }

    public void testOrderAfter2() throws Exception {
        this.assertOrder(this.orderAfterNode, new String[]{"n1", "n2", "n3", "n4", "n5"});
        String path = this.orderAfterNode.getPath();
        String xml = "<D:orderpatch xmlns:D=\"DAV:\"><D:order-member><D:segment>n2</D:segment><D:position><D:after><D:segment>n4</D:segment></D:after></D:position></D:order-member><D:order-member><D:segment>n3</D:segment><D:position><D:after><D:segment>n0</D:segment></D:after></D:position></D:order-member></D:orderpatch>";
        ContainerResponse response = this.service("ORDERPATCH", this.getPathWS() + URLEncoder.encode(path, "UTF-8"), "", null, xml.getBytes());
        TestOrderAfter.assertEquals((int)207, (int)response.getStatus());
        OrderPatchResponseEntity entity = (OrderPatchResponseEntity)response.getEntity();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outputStream);
        String resp = outputStream.toString();
        HierarchicalPropertyEntityProvider entityProvider = new HierarchicalPropertyEntityProvider();
        HierarchicalProperty multistatus = entityProvider.readFrom(null, null, null, null, null, (InputStream)new ByteArrayInputStream(resp.getBytes()));
        TestOrderAfter.assertEquals((Object)new QName("DAV:", "multistatus"), (Object)multistatus.getName());
        TestOrderAfter.assertEquals((int)2, (int)multistatus.getChildren().size());
        HierarchicalProperty responseProp = multistatus.getChild(0);
        String href1MustBe = TextUtil.escape((String)(this.getPathWS() + this.orderAfterNode.getPath() + "/n2"), (char)'%', (boolean)true);
        TestOrderAfter.assertEquals((String)href1MustBe, (String)responseProp.getChild(new QName("DAV:", "href")).getValue());
        String status1 = WebDavConst.getStatusDescription((int)200);
        TestOrderAfter.assertEquals((String)status1, (String)responseProp.getChild(new QName("DAV:", "status")).getValue());
        HierarchicalProperty responseProp2 = multistatus.getChild(1);
        String href2MustBe = TextUtil.escape((String)(this.getPathWS() + this.orderAfterNode.getPath() + "/n3"), (char)'%', (boolean)true);
        TestOrderAfter.assertEquals((String)href2MustBe, (String)responseProp2.getChild(new QName("DAV:", "href")).getValue());
        String status2 = WebDavConst.getStatusDescription((int)403);
        TestOrderAfter.assertEquals((String)status2, (String)responseProp2.getChild(new QName("DAV:", "status")).getValue());
        this.assertOrder(this.orderAfterNode, new String[]{"n1", "n3", "n4", "n2", "n5"});
    }
}

