/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WebDavNamespaceContext
implements NamespaceContext {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.WebDavNamespaceContext");
    private HashMap<String, String> prefixes = new HashMap();
    private HashMap<String, String> namespaces = new HashMap();
    private final NamespaceRegistry namespaceRegistry;

    public WebDavNamespaceContext(Session session) throws RepositoryException {
        this.namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
        this.prefixes.put("DAV:", "D");
        this.namespaces.put("D", "DAV:");
    }

    public QName createQName(String strName) {
        String[] parts = strName.split(":");
        if (parts.length > 1) {
            return new QName(this.getNamespaceURI(parts[0]), parts[1], parts[0]);
        }
        return new QName(parts[0]);
    }

    public static String createName(QName qName) {
        return qName.getPrefix() + ":" + qName.getLocalPart();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String uri = null;
        try {
            uri = this.namespaceRegistry.getURI(prefix);
        }
        catch (NamespaceException exc) {
            uri = this.namespaces.get(prefix);
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
        }
        return uri;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        String prefix = null;
        try {
            prefix = this.namespaceRegistry.getPrefix(namespaceURI);
        }
        catch (NamespaceException exc) {
            prefix = this.prefixes.get(namespaceURI);
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
        }
        return prefix;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getPrefix(namespaceURI));
        return list.iterator();
    }
}

