/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.StreamingOutput;
import org.exoplatform.services.jcr.webdav.Range;
import org.exoplatform.services.jcr.webdav.resource.FileResource;
import org.exoplatform.services.jcr.webdav.resource.Resource;
import org.exoplatform.services.jcr.webdav.resource.VersionResource;
import org.exoplatform.services.jcr.webdav.util.RangedInputStream;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MultipartByterangesEntity
implements StreamingOutput {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.webdav.MultipartByterangesEntity");
    private final Resource resource_;
    private final List<Range> ranges_;
    private final long contentLength_;
    private final String contentType_;

    public MultipartByterangesEntity(Resource resource, List<Range> ranges, String contentType, long contentLength) {
        this.resource_ = resource;
        this.ranges_ = ranges;
        this.contentLength_ = contentLength;
        this.contentType_ = contentType;
    }

    public void write(OutputStream ostream) throws IOException {
        try {
            for (Range range : this.ranges_) {
                InputStream istream = null;
                istream = this.resource_ instanceof VersionResource ? ((VersionResource)this.resource_).getContentAsStream() : ((FileResource)this.resource_).getContentAsStream();
                this.println(ostream);
                this.print("--1234567890", ostream);
                this.println(ostream);
                this.print("Content-Type: " + this.contentType_, ostream);
                this.println(ostream);
                this.print("Content-Range: bytes " + range.getStart() + "-" + range.getEnd() + "/" + this.contentLength_, ostream);
                this.println(ostream);
                this.println(ostream);
                RangedInputStream rangedInputStream = new RangedInputStream(istream, range.getStart(), range.getEnd());
                byte[] buff = new byte[4096];
                int rd = -1;
                while ((rd = rangedInputStream.read(buff)) != -1) {
                    ostream.write(buff, 0, rd);
                }
                rangedInputStream.close();
            }
            this.println(ostream);
            this.print("--1234567890--", ostream);
            this.println(ostream);
        }
        catch (IOException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            throw new IOException("Can't write to stream, caused " + String.valueOf(exc), exc);
        }
        catch (RepositoryException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            throw new IOException("Can't write to stream, caused " + String.valueOf((Object)exc), exc);
        }
    }

    private void print(String s, OutputStream ostream) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            ostream.write(c);
        }
    }

    private void println(OutputStream ostream) throws IOException {
        ostream.write(13);
        ostream.write(10);
    }
}

