/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.connectors.jcr.ejb21;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.exoplatform.common.transport.SerialInputData;
import org.exoplatform.common.transport.SerialRequest;
import org.exoplatform.common.transport.SerialResponse;
import org.exoplatform.connectors.jcr.ejb21.JcrRestEJBConnector;
import org.exoplatform.connectors.jcr.ejb21.JcrRestEJBConnectorHome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    private static final String BEAN_NAME = "JcrRestEJBConnector";
    private static final String DEFAULT_JCR_PATH = "/jcr/repository/production/";
    private static final String DEFAULT_AS_URL = "rmi://127.0.0.1:1099";
    private static final String data = "Hello world";
    private String serverUrl;
    private String jcrUrl;

    public String getServerUrl() {
        if (this.serverUrl == null || this.serverUrl.length() == 0) {
            this.serverUrl = DEFAULT_AS_URL;
        }
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public String getJcrUrl() {
        if (this.jcrUrl == null || this.jcrUrl.length() == 0) {
            this.jcrUrl = DEFAULT_JCR_PATH;
        }
        return this.jcrUrl;
    }

    public void setJcrUrl(String url) {
        this.jcrUrl = url.endsWith("/") ? url : url + "/";
    }

    private JcrRestEJBConnector getBean() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.provider.url", this.getServerUrl());
        props.put("java.naming.factory.initial", "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory");
        InitialContext ctx = new InitialContext(props);
        Object obj = ctx.lookup(BEAN_NAME);
        JcrRestEJBConnectorHome beanhome = (JcrRestEJBConnectorHome)PortableRemoteObject.narrow((Object)obj, JcrRestEJBConnectorHome.class);
        return beanhome.create();
    }

    public String run() throws Exception {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(buf);
        out.println("Looking for JcrRestEJBConnector...");
        JcrRestEJBConnector bean = this.getBean();
        SerialResponse response = null;
        String testDir1 = this.getJcrUrl() + "test " + System.currentTimeMillis();
        out.println("MKCOL : create directory : " + testDir1);
        response = bean.service(Client.createRequest("MKCOL", testDir1, null, null, null));
        out.println(response.getStatus());
        if (response.getData() != null) {
            Client.printStream(response.getData().getStream(), out);
        }
        out.println("PUT : upload file in created directory");
        response = bean.service(Client.createRequest("PUT", testDir1 + "/test.txt", null, null, new SerialInputData(data.getBytes())));
        out.println(response.getStatus());
        if (response.getData() != null) {
            Client.printStream(response.getData().getStream(), out);
        }
        String testDir2 = this.getJcrUrl() + "test " + System.currentTimeMillis();
        out.println("MKCOL : create directory : " + testDir2);
        response = bean.service(Client.createRequest("MKCOL", testDir2, null, null, null));
        out.println(response.getStatus());
        if (response.getData() != null) {
            Client.printStream(response.getData().getStream(), out);
        }
        out.println("COPY : copy file from " + testDir1 + " to " + testDir2);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Destination", testDir2 + "/test.txt");
        response = bean.service(Client.createRequest("COPY", testDir1 + "/test.txt", headers, null, null));
        out.println(response.getStatus());
        if (response.getData() != null) {
            Client.printStream(response.getData().getStream(), out);
        }
        out.println("DELETE : delete first file");
        response = bean.service(Client.createRequest("DELETE", testDir1 + "/test.txt", null, null, null));
        out.println(response.getStatus());
        if (response.getData() != null) {
            Client.printStream(response.getData().getStream(), out);
        }
        out.println("MOVE : move file from " + testDir2 + " to " + testDir1);
        headers = new HashMap();
        headers.put("Destination", testDir1 + "/test.txt");
        response = bean.service(Client.createRequest("MOVE", testDir2 + "/test.txt", headers, null, null));
        out.println(response.getStatus());
        if (response.getData() != null) {
            Client.printStream(response.getData().getStream(), out);
        }
        out.println("DELETE : delete directory " + testDir2);
        response = bean.service(Client.createRequest("DELETE", testDir2, null, null, null));
        out.println(response.getStatus());
        if (response.getData() != null) {
            Client.printStream(response.getData().getStream(), out);
        }
        out.println("GET : get file " + testDir1 + "/test.txt");
        response = bean.service(Client.createRequest("GET", testDir1 + "/test.txt", null, null, null));
        out.println(response.getStatus());
        if (response.getData() != null) {
            Client.printStream(response.getData().getStream(), out);
        }
        out.println("DELETE : delete directory " + testDir1);
        response = bean.service(Client.createRequest("DELETE", testDir1, null, null, null));
        out.println(response.getStatus());
        if (response.getData() != null) {
            Client.printStream(response.getData().getStream(), out);
        }
        out.flush();
        out.close();
        return buf.toString("UTF-8");
    }

    private static SerialRequest createRequest(String method, String url, HashMap<String, String> headers, HashMap<String, String> queries, SerialInputData data) {
        SerialRequest request = new SerialRequest();
        request.setMethod(method);
        request.setUrl(url);
        request.setHeaders(headers);
        request.setQueries(queries);
        request.setData(data);
        return request;
    }

    private static void printStream(InputStream in, PrintWriter out) throws IOException {
        int rd = -1;
        while ((rd = in.read()) != -1) {
            out.print((char)rd);
        }
        out.print('\n');
    }
}

