/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.frameworks.jcr;

import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * Created by The eXo Platform SAS .<br/> Provides JCR Session for client
 * program. Usually it is per client thread object Session creates with
 * Repository.login(..) method and then can be stored in some cache if
 * neccessary.
 * 
 * @deprecated use SessionProvider related mechanism instead
 * 
 * @author <a href="mailto:gennady.azarenkov@exoplatform.com">Gennady Azarenkov</a>
 * @version $Id: JCRAppSessionFactory.java 9129 2006-09-26 12:34:00Z gavrikvetal $
 */

public interface JCRAppSessionFactory {
  /**
   * @param workspaceName
   * @return JCR Session object
   * @throws LoginException
   * @throws NoSuchWorkspaceException
   * @throws RepositoryException
   */
  Session getSession(String workspaceName) throws LoginException,
      NoSuchWorkspaceException, RepositoryException;

  public void close();

}
