/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.commands;

import java.io.OutputStream;
import org.exoplatform.frameworks.ftpclient.FtpUtils;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSession;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommand;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class FtpCommandImpl
implements FtpCommand {
    private static Log log = ExoLogger.getLogger((String)"exo.ftpclient.FtpCommandImpl");
    protected FtpClientSession clientSession;
    protected int replyCode;
    protected String descript = "";

    public int run(FtpClientSession clientSession) {
        this.clientSession = clientSession;
        try {
            int status = this.execute();
            return status;
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return -1;
        }
    }

    public abstract int execute();

    public void sendCommand(String command) {
        log.info((Object)(">>> " + command));
        try {
            byte[] data = command.getBytes();
            OutputStream outStream = this.clientSession.getClientSocket().getOutputStream();
            outStream.write(data);
            outStream.write("\r\n".getBytes());
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
    }

    private boolean isReplyString(String replyString) {
        if (replyString.length() < 4) {
            return false;
        }
        return replyString.charAt(0) >= '0' && replyString.charAt(0) <= '9' && replyString.charAt(1) >= '0' && replyString.charAt(1) <= '9' && replyString.charAt(2) >= '0' && replyString.charAt(2) <= '9' && replyString.charAt(3) == ' ';
    }

    public int getReply() throws Exception {
        log.info((Object)"try get reply..........");
        String reply = "";
        String curReply = "";
        while (true) {
            if ("".equals(curReply = this.readLine())) {
                reply = reply + "\r\n";
                continue;
            }
            reply = reply + curReply;
            if (this.isReplyString(curReply)) break;
            reply = reply + "\r\n";
        }
        this.descript = reply;
        this.replyCode = FtpUtils.getReplyCode(curReply);
        log.info((Object)("<<< " + this.descript));
        return this.replyCode;
    }

    public String getDescription() {
        return this.descript;
    }

    public String readLine() throws Exception {
        byte[] buffer = new byte[4096];
        int bufPos = 0;
        int prevByte = 0;
        int received;
        while ((received = this.clientSession.getClientSocket().getInputStream().read()) >= 0) {
            buffer[bufPos] = (byte)received;
            ++bufPos;
            if (prevByte == 13 && received == 10) {
                String resultLine = "";
                for (int i = 0; i < bufPos - 2; ++i) {
                    resultLine = resultLine + (char)buffer[i];
                }
                return resultLine;
            }
            prevByte = (byte)received;
        }
        return null;
    }
}

