/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.commands;

import java.util.ArrayList;
import org.exoplatform.frameworks.ftpclient.commands.CmdSyst;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommandImpl;
import org.exoplatform.frameworks.ftpclient.data.FtpDataTransiver;
import org.exoplatform.frameworks.ftpclient.data.FtpFileInfo;
import org.exoplatform.frameworks.ftpclient.data.FtpFileInfoImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdList
extends FtpCommandImpl {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.framework.command.CmdList");
    protected String path = "";
    protected byte[] fileData;
    protected ArrayList<FtpFileInfo> files = new ArrayList();

    public CmdList() {
    }

    public CmdList(String path) {
        this.path = path;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public ArrayList<FtpFileInfo> getFiles() {
        return this.files;
    }

    @Override
    public int execute() {
        try {
            if (this.clientSession.getSystemType() == null) {
                this.clientSession.executeCommand(new CmdSyst());
            }
            String req = "".equals(this.path) ? "LIST" : String.format("%s %s", "LIST", this.path);
            this.sendCommand(req);
            int reply = this.getReply();
            if (reply == 125 || reply == 150) {
                FtpDataTransiver dataTransiver = this.clientSession.getDataTransiver();
                this.fileData = dataTransiver.receive();
                dataTransiver.close();
                String dd = new String(this.fileData, "utf-8");
                String[] lines = dd.split("\r\n");
                String systemType = this.clientSession.getSystemType();
                systemType = systemType.substring(systemType.indexOf(" ") + 1);
                for (int i = 0; i < lines.length; ++i) {
                    try {
                        FtpFileInfoImpl fileInfo = new FtpFileInfoImpl();
                        if ("".equals(lines[i])) continue;
                        fileInfo.parseDir(lines[i], systemType);
                        this.files.add(fileInfo);
                        continue;
                    }
                    catch (Exception exc) {
                        LOG.info((Object)("CAN'T PARSE FILE LINE: [" + lines[i] + "]"));
                    }
                }
                reply = this.getReply();
            }
            return reply;
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return -1;
        }
    }
}

