/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.cmdtests;

import junit.framework.TestCase;
import org.exoplatform.frameworks.ftpclient.FtpTestConfig;
import org.exoplatform.frameworks.ftpclient.Log;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSession;
import org.exoplatform.frameworks.ftpclient.commands.CmdCwd;
import org.exoplatform.frameworks.ftpclient.commands.CmdDele;
import org.exoplatform.frameworks.ftpclient.commands.CmdPass;
import org.exoplatform.frameworks.ftpclient.commands.CmdPasv;
import org.exoplatform.frameworks.ftpclient.commands.CmdRest;
import org.exoplatform.frameworks.ftpclient.commands.CmdStor;
import org.exoplatform.frameworks.ftpclient.commands.CmdUser;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommand;

public class STORTest
extends TestCase {
    private static Log log = new Log("STORTest");

    public void testSTOR() throws Exception {
        log.info("Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        byte[] fileContent = "THIS FILE CONTENT".getBytes();
        CmdStor cmdStor = new CmdStor(null);
        cmdStor.setFileContent(fileContent);
        STORTest.assertEquals((int)530, (int)client.executeCommand((FtpCommand)cmdStor));
        STORTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        STORTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        cmdStor = new CmdStor(null);
        cmdStor.setFileContent(fileContent);
        STORTest.assertEquals((int)425, (int)client.executeCommand((FtpCommand)cmdStor));
        STORTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        cmdStor = new CmdStor(null);
        cmdStor.setFileContent(fileContent);
        STORTest.assertEquals((int)500, (int)client.executeCommand((FtpCommand)cmdStor));
        String fileName = "test_stor_file_" + System.currentTimeMillis() + ".txt";
        STORTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        CmdStor cmdStor2 = new CmdStor(fileName);
        cmdStor2.setFileContent(fileContent);
        STORTest.assertEquals((int)550, (int)client.executeCommand((FtpCommand)cmdStor2));
        STORTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdCwd("production")));
        STORTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        cmdStor2 = new CmdStor(fileName);
        cmdStor2.setFileContent(fileContent);
        STORTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdStor2));
        STORTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        STORTest.assertEquals((int)350, (int)client.executeCommand((FtpCommand)new CmdRest(1000)));
        cmdStor2 = new CmdStor(fileName);
        cmdStor2.setFileContent(fileContent);
        STORTest.assertEquals((int)550, (int)client.executeCommand((FtpCommand)cmdStor2));
        STORTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdDele(fileName)));
        client.close();
        log.info("Complete.\r\n");
    }

    public void testForbiddenChars_STOR() throws Exception {
        log.info("Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        byte[] fileContent = "THIS FILE CONTENT".getBytes();
        STORTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        STORTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        String fileName = "test_stor_file_:[]*'\"|.txt";
        STORTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdCwd("production")));
        STORTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        CmdStor cmdStor = new CmdStor(fileName);
        cmdStor.setFileContent(fileContent);
        STORTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdStor));
        STORTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdDele("test_stor_file________.txt")));
        client.close();
        log.info("Complete.\r\n");
    }
}

