/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.commands;

import org.exoplatform.frameworks.ftpclient.commands.FtpCommandImpl;
import org.exoplatform.frameworks.ftpclient.data.FtpDataTransiver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdStor
extends FtpCommandImpl {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.framework.command.CmdStor");
    protected String path;
    protected byte[] fileContent = null;

    public CmdStor(String path) {
        this.path = path;
    }

    public void setFileContent(byte[] fileContent) {
        this.fileContent = fileContent;
    }

    @Override
    public int execute() {
        if (this.fileContent == null) {
            return -1;
        }
        try {
            FtpDataTransiver dataTransiver = this.clientSession.getDataTransiver();
            if (dataTransiver != null) {
                for (int i = 0; i < 150; ++i) {
                    if (dataTransiver.isConnected()) continue;
                    Thread.sleep(100L);
                }
            }
            if (this.path == null) {
                this.sendCommand("STOR");
                return this.getReply();
            }
            this.sendCommand(String.format("%s %s", "STOR", this.path));
            int reply = this.getReply();
            if (reply == 125) {
                dataTransiver.send(this.fileContent);
                reply = this.getReply();
            }
            return reply;
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return -1;
        }
    }
}

