/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient;

import java.util.Random;
import junit.framework.TestCase;
import org.exoplatform.frameworks.ftpclient.FtpTestConfig;
import org.exoplatform.frameworks.ftpclient.FtpUtils;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSession;
import org.exoplatform.frameworks.ftpclient.commands.CmdCdUp;
import org.exoplatform.frameworks.ftpclient.commands.CmdCwd;
import org.exoplatform.frameworks.ftpclient.commands.CmdDele;
import org.exoplatform.frameworks.ftpclient.commands.CmdList;
import org.exoplatform.frameworks.ftpclient.commands.CmdMkd;
import org.exoplatform.frameworks.ftpclient.commands.CmdNlst;
import org.exoplatform.frameworks.ftpclient.commands.CmdNoop;
import org.exoplatform.frameworks.ftpclient.commands.CmdPass;
import org.exoplatform.frameworks.ftpclient.commands.CmdPasv;
import org.exoplatform.frameworks.ftpclient.commands.CmdPort;
import org.exoplatform.frameworks.ftpclient.commands.CmdPwd;
import org.exoplatform.frameworks.ftpclient.commands.CmdRest;
import org.exoplatform.frameworks.ftpclient.commands.CmdRetr;
import org.exoplatform.frameworks.ftpclient.commands.CmdRmd;
import org.exoplatform.frameworks.ftpclient.commands.CmdRnFr;
import org.exoplatform.frameworks.ftpclient.commands.CmdRnTo;
import org.exoplatform.frameworks.ftpclient.commands.CmdSize;
import org.exoplatform.frameworks.ftpclient.commands.CmdStor;
import org.exoplatform.frameworks.ftpclient.commands.CmdSyst;
import org.exoplatform.frameworks.ftpclient.commands.CmdType;
import org.exoplatform.frameworks.ftpclient.commands.CmdUser;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommand;
import org.exoplatform.frameworks.ftpclient.data.FtpDataTransiver;
import org.exoplatform.frameworks.ftpclient.data.FtpDataTransiverImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpTest
extends TestCase {
    protected static final String FILE_CONTENT = "eXo TEST File Content...";

    protected static Log getLogger(String unitName) {
        return ExoLogger.getLogger((String)("exo.jcr.framework.command." + unitName));
    }

    public void testNOOP() throws Exception {
        Log log = FtpTest.getLogger("NOOP");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)200, (int)client.executeCommand((FtpCommand)new CmdNoop()));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testUSER() throws Exception {
        Log log = FtpTest.getLogger("USER");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testPASS() throws Exception {
        Log log = FtpTest.getLogger("PASS");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testSYST() throws Exception {
        Log log = FtpTest.getLogger("SYST");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        log.info((Object)"Complete.");
    }

    public void testPWD() throws Exception {
        Log log = FtpTest.getLogger("PWD");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        CmdPwd cmdPwd = new CmdPwd();
        FtpTest.assertEquals((int)257, (int)client.executeCommand((FtpCommand)cmdPwd));
        log.info((Object)("CURRENTPATH - [" + cmdPwd.getCurrentPath() + "]"));
        log.info((Object)"Complete.");
    }

    public void testCWD() throws Exception {
        Log log = FtpTest.getLogger("CWD");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdCwd("production")));
        CmdPwd cmdPwd = new CmdPwd();
        FtpTest.assertEquals((int)257, (int)client.executeCommand((FtpCommand)cmdPwd));
        FtpTest.assertEquals((String)"/production", (String)cmdPwd.getCurrentPath());
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdCwd("../backup/")));
        cmdPwd = new CmdPwd();
        FtpTest.assertEquals((int)257, (int)client.executeCommand((FtpCommand)cmdPwd));
        FtpTest.assertEquals((String)"/backup", (String)cmdPwd.getCurrentPath());
        FtpTest.assertEquals((int)550, (int)client.executeCommand((FtpCommand)new CmdCwd("production")));
        client.close();
        client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)530, (int)client.executeCommand((FtpCommand)new CmdCwd("production")));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testCDUP() throws Exception {
        Log log = FtpTest.getLogger("CDUP");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdCwd("production")));
        CmdPwd cmdPwd = new CmdPwd();
        FtpTest.assertEquals((int)257, (int)client.executeCommand((FtpCommand)cmdPwd));
        FtpTest.assertEquals((String)"/production", (String)cmdPwd.getCurrentPath());
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdCdUp()));
        cmdPwd = new CmdPwd();
        FtpTest.assertEquals((int)257, (int)client.executeCommand((FtpCommand)cmdPwd));
        FtpTest.assertEquals((String)"/", (String)cmdPwd.getCurrentPath());
        client.close();
        log.info((Object)"Complete.");
    }

    public void testTYPE() throws Exception {
        Log log = FtpTest.getLogger("TYPE");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)200, (int)client.executeCommand((FtpCommand)new CmdType("A")));
        FtpTest.assertEquals((int)200, (int)client.executeCommand((FtpCommand)new CmdType("I")));
        FtpTest.assertEquals((int)500, (int)client.executeCommand((FtpCommand)new CmdType("SOMETYPE")));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testPASV() throws Exception {
        Log log = FtpTest.getLogger("PASV");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        boolean connected = false;
        for (int i = 0; i < 15; ++i) {
            try {
                if (client.getDataTransiver().isConnected()) {
                    connected = true;
                    break;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
        FtpTest.assertEquals((boolean)true, (boolean)connected);
        client.getDataTransiver().close();
        client.close();
        log.info((Object)"Complete.");
    }

    public void testPORT() throws Exception {
        Log log = FtpTest.getLogger("PORT");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        int MIN_PORT_VAL = 9000;
        int MAX_PORT_VAL = 10000;
        int ports = MAX_PORT_VAL - MIN_PORT_VAL + 1;
        Random random = new Random();
        String host = "127.0.0.1";
        int port = 0;
        boolean enableSearch = true;
        while (enableSearch) {
            port = MIN_PORT_VAL + random.nextInt(ports);
            if (!FtpUtils.isPortFree((int)port)) continue;
            enableSearch = false;
        }
        FtpDataTransiverImpl dataTransiver = new FtpDataTransiverImpl();
        dataTransiver.OpenActive(port);
        client.setDataTransiver((FtpDataTransiver)dataTransiver);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
        CmdPort cmdPort = new CmdPort(host, port);
        FtpTest.assertEquals((int)200, (int)client.executeCommand((FtpCommand)cmdPort));
        boolean connected = false;
        for (int i = 0; i < 15; ++i) {
            try {
                if (client.getDataTransiver().isConnected()) {
                    connected = true;
                    break;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
        FtpTest.assertEquals((boolean)true, (boolean)connected);
        client.getDataTransiver().close();
        client.close();
        log.info((Object)"Complete.");
    }

    public void testLIST() throws Exception {
        Log log = FtpTest.getLogger("LIST");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdCwd("production")));
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)new CmdList()));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testNLST() throws Exception {
        Log log = FtpTest.getLogger("NLST");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdCwd("production")));
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)new CmdNlst()));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testMKD() throws Exception {
        Log log = FtpTest.getLogger("MKD");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        FtpTest.assertEquals((int)257, (int)client.executeCommand((FtpCommand)new CmdMkd("/production/test_folder")));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testRMD() throws Exception {
        Log log = FtpTest.getLogger("RMD");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        FtpTest.assertEquals((int)257, (int)client.executeCommand((FtpCommand)new CmdMkd("/production/test_folder")));
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdRmd("/production/test_folder")));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testRNFR_RNTO() throws Exception {
        Log log = FtpTest.getLogger("RNFR_RNTO");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        FtpTest.assertEquals((int)257, (int)client.executeCommand((FtpCommand)new CmdMkd("/production/test_kokanoid_torename")));
        FtpTest.assertEquals((int)350, (int)client.executeCommand((FtpCommand)new CmdRnFr("/production/test_kokanoid_torename")));
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdRnTo("/production/test_kokanoid_renamed")));
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdRmd("/production/test_kokanoid_renamed")));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testSTOR() throws Exception {
        Log log = FtpTest.getLogger("STOR");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        CmdStor cmdStor = new CmdStor("/production/test_file.txt");
        byte[] data = new byte[FILE_CONTENT.length()];
        char[] chars = FILE_CONTENT.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)chars[i];
        }
        cmdStor.setFileContent(data);
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdStor));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testSIZE() throws Exception {
        Log log = FtpTest.getLogger("SIZE");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        FtpTest.assertEquals((int)213, (int)client.executeCommand((FtpCommand)new CmdSize("/production/test_file.txt")));
        FtpTest.assertEquals((int)550, (int)client.executeCommand((FtpCommand)new CmdSize("/production/test_file_absent.txt")));
        client.close();
        log.info((Object)"Complete.");
    }

    public void testRETR() throws Exception {
        Log log = FtpTest.getLogger("RETR");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        CmdRetr cmdRetr = new CmdRetr("/production/test_file.txt");
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdRetr));
        byte[] fileContent = cmdRetr.getFileContent();
        FtpTest.assertEquals((int)fileContent.length, (int)FILE_CONTENT.length());
        for (int i = 0; i < fileContent.length; ++i) {
            if (fileContent[i] == FILE_CONTENT.charAt(i)) continue;
            FtpTest.fail();
        }
        client.close();
        log.info((Object)"Complete.");
    }

    public void testREST() throws Exception {
        Log log = FtpTest.getLogger("REST");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        FtpTest.assertEquals((int)350, (int)client.executeCommand((FtpCommand)new CmdRest(9)));
        CmdRetr cmdRetr = new CmdRetr("/production/test_file.txt");
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdRetr));
        byte[] fileContent = cmdRetr.getFileContent();
        FtpTest.assertEquals((int)fileContent.length, (int)(FILE_CONTENT.length() - 9));
        for (int i = 0; i < fileContent.length; ++i) {
            if (fileContent[i] == FILE_CONTENT.charAt(i + 9)) continue;
            FtpTest.fail();
        }
        client.close();
        log.info((Object)"Complete.");
    }

    public void testDELE() throws Exception {
        Log log = FtpTest.getLogger("DELE");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdDele("/production/test_file.txt")));
        client.close();
        log.info((Object)"Complete.");
    }

    protected byte[] getBytes(String content) {
        byte[] data = new byte[content.length()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)content.charAt(i);
        }
        return data;
    }

    public void testREST_STOR() throws Exception {
        Log log = FtpTest.getLogger("REST_STOR");
        log.info((Object)"Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        FtpTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        FtpTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        FtpTest.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
        String fileName = "/production/resr_test_file.txt";
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        byte[] data = this.getBytes("DATABYTES");
        CmdStor cmdStor = new CmdStor(fileName);
        cmdStor.setFileContent(data);
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdStor));
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        CmdRetr cmdRetr = new CmdRetr(fileName);
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdRetr));
        byte[] dataAfter = cmdRetr.getFileContent();
        for (int i = 0; i < dataAfter.length; ++i) {
            if (dataAfter[i] == data[i]) continue;
            FtpTest.fail();
        }
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        FtpTest.assertEquals((int)350, (int)client.executeCommand((FtpCommand)new CmdRest(data.length)));
        byte[] secondData = this.getBytes("_APPENDED");
        cmdStor = new CmdStor(fileName);
        cmdStor.setFileContent(secondData);
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdStor));
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        cmdRetr = new CmdRetr(fileName);
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdRetr));
        String secondString = "DATABYTES_APPENDED";
        byte[] secondDataAfter = cmdRetr.getFileContent();
        for (int i = 0; i < secondDataAfter.length; ++i) {
            if (secondDataAfter[i] == (byte)secondString.charAt(i)) continue;
            FtpTest.fail();
        }
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        FtpTest.assertEquals((int)350, (int)client.executeCommand((FtpCommand)new CmdRest(4)));
        byte[] replasedData = this.getBytes("INT");
        cmdStor = new CmdStor(fileName);
        cmdStor.setFileContent(replasedData);
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdStor));
        FtpTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        cmdRetr = new CmdRetr(fileName);
        FtpTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdRetr));
        String readyString = "DATAINTES_APPENDED";
        byte[] readyBytes = cmdRetr.getFileContent();
        for (int i = 0; i < readyBytes.length; ++i) {
            if (readyBytes[i] == (byte)readyString.charAt(i)) continue;
            FtpTest.fail();
        }
        FtpTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdDele(fileName)));
        client.close();
        log.info((Object)"Complete.");
    }
}

