/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.cmdtests;

import junit.framework.TestCase;
import org.exoplatform.frameworks.ftpclient.FtpTestConfig;
import org.exoplatform.frameworks.ftpclient.Log;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSession;
import org.exoplatform.frameworks.ftpclient.commands.CmdCwd;
import org.exoplatform.frameworks.ftpclient.commands.CmdDele;
import org.exoplatform.frameworks.ftpclient.commands.CmdPass;
import org.exoplatform.frameworks.ftpclient.commands.CmdPasv;
import org.exoplatform.frameworks.ftpclient.commands.CmdRest;
import org.exoplatform.frameworks.ftpclient.commands.CmdRetr;
import org.exoplatform.frameworks.ftpclient.commands.CmdStor;
import org.exoplatform.frameworks.ftpclient.commands.CmdUser;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommand;

public class RETRTest
extends TestCase {
    private static Log log = new Log("RETRTest");

    public void testRETR() throws Exception {
        log.info("Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        RETRTest.assertEquals((int)530, (int)client.executeCommand((FtpCommand)new CmdRetr(null)));
        RETRTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
        RETRTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
        RETRTest.assertEquals((int)425, (int)client.executeCommand((FtpCommand)new CmdRetr(null)));
        RETRTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        RETRTest.assertEquals((int)500, (int)client.executeCommand((FtpCommand)new CmdRetr(null)));
        String fileName = "test_file_" + System.currentTimeMillis() + ".txt";
        byte[] fileContent = "THIS FILE CONTENT".getBytes();
        RETRTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        RETRTest.assertEquals((int)550, (int)client.executeCommand((FtpCommand)new CmdRetr(fileName)));
        RETRTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdCwd("production")));
        RETRTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        CmdStor cmdStor = new CmdStor(fileName);
        cmdStor.setFileContent(fileContent);
        RETRTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdStor));
        RETRTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        CmdRetr cmdRetr = new CmdRetr(fileName);
        RETRTest.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdRetr));
        RETRTest.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
        RETRTest.assertEquals((int)350, (int)client.executeCommand((FtpCommand)new CmdRest(100000)));
        cmdRetr = new CmdRetr(fileName);
        RETRTest.assertEquals((int)550, (int)client.executeCommand((FtpCommand)cmdRetr));
        RETRTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdDele(fileName)));
        client.close();
        log.info("Complete.\r\n");
    }
}

