/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.frameworks.jcr.command.web.GenericWebAppContext;
import org.exoplatform.services.command.impl.CommandService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class CommandControllerServlet
extends HttpServlet {
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GenericWebAppContext ctx;
        ExoContainer container = (ExoContainer)this.getServletContext().getAttribute("org.exoplatform.frameworks.web.eXoContainer");
        if (container == null) {
            String portalName = this.getServletContext().getServletContextName();
            container = ExoContainerContext.getCurrentContainer();
        }
        SessionProviderService sessionProviderService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        try {
            ctx = new GenericWebAppContext(this.getServletContext(), request, response, sessionProviderService.getSessionProvider(null), repositoryService.getDefaultRepository());
        }
        catch (RepositoryException e) {
            throw new IOException(){

                public Throwable getCause() {
                    return e;
                }
            };
        }
        catch (RepositoryConfigurationException e) {
            throw new IOException(){

                public Throwable getCause() {
                    return e;
                }
            };
        }
        CommandService commandService = (CommandService)container.getComponentInstanceOfType(CommandService.class);
        String catalogName = (String)ctx.get((Object)"org.exoplatform.frameworks.web.catalogName");
        String commandName = (String)ctx.get((Object)"Command");
        if (commandName == null) {
            throw new ServletException("No Command found at the Context");
        }
        Command cmd = catalogName == null ? commandService.getCatalog().getCommand(commandName) : commandService.getCatalog(catalogName).getCommand(commandName);
        if (cmd == null) {
            throw new ServletException("No Command found " + commandName);
        }
        try {
            cmd.execute((Context)ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }
}

