/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

public class ThreadLocalSessionProviderInitializedFilter
implements Filter {
    private ConversationRegistry stateRegistry;
    private SessionProviderService providerService;
    private static final Log log = ExoLogger.getLogger((String)"jcr.ThreadLocalSessionProviderInitializedFilter");

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.providerService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        this.stateRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ConversationState state = ConversationState.getCurrent();
        SessionProvider provider = null;
        HttpSession httpsession = httpRequest.getSession(false);
        if (state == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Current conversation state is not set");
            }
            if (httpsession != null) {
                String httpsessionId = httpsession.getId();
                state = this.stateRegistry.getState((Object)httpsessionId);
                if (state != null) {
                    provider = new SessionProvider(state);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("WARN: Conversation State is null, id  " + httpsessionId));
                }
            }
        } else {
            provider = new SessionProvider(state);
        }
        if (provider == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Create SessionProvider for anonymous.");
            }
            provider = SessionProvider.createAnonimProvider();
        }
        if (ConversationState.getCurrent() != null) {
            ConversationState.getCurrent().setAttribute("JCRsessionProvider", (Object)provider);
        }
        this.providerService.setSessionProvider(null, provider);
        chain.doFilter(request, response);
        if (ConversationState.getCurrent() != null) {
            ConversationState.getCurrent().removeAttribute("JCRsessionProvider");
        }
        this.providerService.removeSessionProvider(null);
    }

    public void destroy() {
    }
}

