/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.properties;

import org.exoplatform.frameworks.webdavclient.XmlUtil;
import org.exoplatform.frameworks.webdavclient.http.Log;
import org.exoplatform.frameworks.webdavclient.properties.CommonProp;
import org.w3c.dom.Node;

public class LockDiscoveryProp
extends CommonProp {
    protected ActiveLock activeLock;

    public LockDiscoveryProp() {
        this.propertyName = "lockdiscovery";
    }

    public boolean init(Node node) {
        Node activeLockN = XmlUtil.getChildNode(node, "activelock");
        if (activeLockN == null) {
            return false;
        }
        this.activeLock = new ActiveLock(activeLockN);
        return true;
    }

    public ActiveLock getActiveLock() {
        return this.activeLock;
    }

    public class ActiveLock {
        protected String lockType = "write";
        protected String lockScope = "exclusive";
        protected String depth = "Infinity";
        protected String owner = "gavrik-vetal@ukr.net";
        protected String lockToken = "";
        protected boolean enabled = false;

        public ActiveLock(Node node) {
            try {
                Node scopeExclusiveN;
                Node lockScopeN;
                Node scopeSharedN;
                Node lockTypeN = XmlUtil.getChildNode(node, "locktype");
                Node typeWriteN = XmlUtil.getChildNode(lockTypeN, "write");
                if (typeWriteN != null) {
                    this.lockType = "write";
                }
                if ((scopeSharedN = XmlUtil.getChildNode(lockScopeN = XmlUtil.getChildNode(node, "lockscope"), "shared")) != null) {
                    this.lockScope = "shared";
                }
                if ((scopeExclusiveN = XmlUtil.getChildNode(lockScopeN, "exclusive")) != null) {
                    this.lockScope = "exclusive";
                }
                Node depthN = XmlUtil.getChildNode(node, "depth");
                this.depth = depthN.getTextContent();
                Node ownerN = XmlUtil.getChildNode(node, "owner");
                this.owner = ownerN.getTextContent();
                Node lockTokenN = XmlUtil.getChildNode(node, "locktoken");
                if (lockTokenN != null) {
                    Node lockTokenHref = XmlUtil.getChildNode(lockTokenN, "href");
                    Node lockTokenNode = lockTokenN;
                    if (lockTokenHref != null) {
                        lockTokenNode = lockTokenHref;
                    }
                    this.lockToken = lockTokenNode.getTextContent();
                }
                this.enabled = true;
            }
            catch (Exception exc) {
                Log.info("Unhandled exception. " + exc.getMessage(), exc);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getLockType() {
            return this.lockType;
        }

        public String getLockScope() {
            return this.lockScope;
        }

        public String getDepth() {
            return this.depth;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getLockToken() {
            return this.lockToken;
        }
    }
}

