/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.commands;

import org.exoplatform.frameworks.webdavclient.WebDavContext;
import org.exoplatform.frameworks.webdavclient.commands.DavCommand;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DavLabel
extends DavCommand {
    public static final String ADD = "add";
    public static final String SET = "set";
    public static final String REMOVE = "remove";
    public static final String XML_LABELNAME = "label-name";
    private String action = "add";
    private String labelName;

    public DavLabel(WebDavContext context) throws Exception {
        super(context);
        this.commandName = "LABEL";
    }

    public void addLabel(String labelName) {
        this.labelName = labelName;
        this.action = ADD;
    }

    public void setLabel(String labelName) {
        this.labelName = labelName;
        this.action = SET;
    }

    public void removeLabel(String labelName) {
        this.labelName = labelName;
        this.action = REMOVE;
    }

    public Element toXml(Document xmlDocument) {
        Element labelElement = xmlDocument.createElementNS("DAV:", "A:label");
        xmlDocument.appendChild(labelElement);
        Element actionElement = xmlDocument.createElement("A:" + this.action);
        labelElement.appendChild(actionElement);
        Element labelNameElement = xmlDocument.createElement("A:label-name");
        actionElement.appendChild(labelNameElement);
        labelNameElement.setTextContent(this.labelName);
        return labelElement;
    }
}

