/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.properties;

import java.util.ArrayList;
import org.exoplatform.frameworks.webdavclient.XmlUtil;
import org.exoplatform.frameworks.webdavclient.properties.CommonProp;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportedQueryGrammarSetProp
extends CommonProp {
    private boolean basicSearchEnable = false;
    private ArrayList<String> grammars = new ArrayList();

    public SupportedQueryGrammarSetProp() {
        this.propertyName = "supported-query-grammar-set";
    }

    @Override
    public boolean init(Node node) {
        if (this.status != 200) {
            return false;
        }
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            String childNodeName = childNode.getLocalName();
            if (childNodeName == null || !"supported-query-grammar".equalsIgnoreCase(childNodeName) || !"DAV:".equals(childNode.getNamespaceURI())) continue;
            Node grammarNode = XmlUtil.getChildNode(childNode, "grammar");
            NodeList grammarNodes = grammarNode.getChildNodes();
            for (int gi = 0; gi < grammarNodes.getLength(); ++gi) {
                Node queryGrammarNode = grammarNodes.item(gi);
                String queryName = queryGrammarNode.getLocalName();
                if (queryName == null) continue;
                if ("basicsearch".equalsIgnoreCase(queryName) && "DAV:".equals(queryGrammarNode.getNamespaceURI())) {
                    this.basicSearchEnable = true;
                    continue;
                }
                this.grammars.add(queryName);
            }
        }
        return true;
    }

    public boolean isBasicSearchEnabled() {
        return this.basicSearchEnable;
    }

    public ArrayList<String> getGrammars() {
        return this.grammars;
    }
}

