/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.commands;

import org.exoplatform.frameworks.webdavclient.WebDavContext;
import org.exoplatform.frameworks.webdavclient.commands.DavCommand;
import org.exoplatform.frameworks.webdavclient.documents.DocumentApi;
import org.exoplatform.frameworks.webdavclient.documents.DocumentManager;
import org.exoplatform.frameworks.webdavclient.documents.PropDoc;
import org.exoplatform.frameworks.webdavclient.http.Log;
import org.exoplatform.frameworks.webdavclient.properties.LockDiscoveryProp;
import org.exoplatform.frameworks.webdavclient.properties.PropApi;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DavLock
extends DavCommand {
    protected DocumentApi propDocument = null;
    protected String lockToken = "";
    protected int depth = 0;
    protected int timeOut = Integer.MAX_VALUE;

    public DavLock(WebDavContext context) throws Exception {
        super(context);
        this.commandName = "LOCK";
        this.client.setRequestHeader("connection", "TE");
        this.client.setRequestHeader("te", "trailers");
        this.client.setRequestHeader("content-type", "application/xml");
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public void finalExecute() {
        try {
            if (this.client.getReplyCode() != 200) {
                return;
            }
            this.lockToken = this.client.getResponseHeader("Lock-Token");
            this.lockToken = this.lockToken.substring(1, this.lockToken.length() - 1);
            this.propDocument = DocumentManager.getResponseDocument(this.client.getResponseStream());
        }
        catch (Exception exc) {
            Log.info("Unhandled exception. " + exc.getMessage());
        }
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public DocumentApi getLockDocument() {
        return this.propDocument;
    }

    public LockDiscoveryProp.ActiveLock getActiveLock() {
        if (!(this.propDocument instanceof PropDoc)) {
            return null;
        }
        PropApi property = ((PropDoc)this.propDocument).getSingleProperty();
        if (!(property instanceof LockDiscoveryProp)) {
            return null;
        }
        return ((LockDiscoveryProp)property).getActiveLock();
    }

    public int execute() throws Exception {
        this.client.setRequestHeader("Depth", "" + this.depth);
        this.client.setRequestHeader("Timeout", "Second-" + this.timeOut);
        return super.execute();
    }

    public Element toXml(Document xmlDocument) {
        Element lockInfoEl = xmlDocument.createElementNS("DAV:", "A:lockinfo");
        xmlDocument.appendChild(lockInfoEl);
        Element lockScopeEl = xmlDocument.createElement("A:lockscope");
        lockInfoEl.appendChild(lockScopeEl);
        Element scopeExclusive = xmlDocument.createElement("A:exclusive");
        lockScopeEl.appendChild(scopeExclusive);
        Element lockTypeEl = xmlDocument.createElement("A:locktype");
        lockInfoEl.appendChild(lockTypeEl);
        Element typeWrite = xmlDocument.createElement("A:write");
        lockTypeEl.appendChild(typeWrite);
        Element ownerEl = xmlDocument.createElement("A:owner");
        lockInfoEl.appendChild(ownerEl);
        ownerEl.setTextContent("gavrik-vetal@ukr.net");
        return lockInfoEl;
    }
}

