/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.artifact;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.artifact.ArtifactDescriptor;
import org.exoplatform.services.jcr.ext.artifact.ArtifactManagingService;
import org.exoplatform.services.jcr.ext.artifact.CRCGenerator;
import org.exoplatform.services.jcr.ext.artifact.DefaultFileFilter;
import org.exoplatform.services.jcr.ext.artifact.Descriptor;
import org.exoplatform.services.jcr.ext.artifact.FolderDescriptor;
import org.exoplatform.services.jcr.ext.artifact.SearchCriteria;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ArtifactManagingServiceImpl
implements ArtifactManagingService,
Startable {
    private static final int BUFFER = 4096;
    private static final String STRING_TERMINATOR = "*";
    private static final String NT_FILE = "artifact-nodetypes.xml";
    private static final String SERVICE_NAME = "ArtifactManaging";
    private RepositoryService repositoryService;
    private RegistryService registryService;
    private SessionProvider sessionProvider;
    private InitParams initParams;
    private String repoWorkspaceName;
    private String rootNodePath;
    private static final Log LOG = ExoLogger.getLogger(ArtifactManagingServiceImpl.class);
    private Map<String, String> mimeMap = new Hashtable<String, String>();
    private List<String> listErrorPom = new ArrayList<String>();

    public ArtifactManagingServiceImpl(InitParams initParams, RepositoryService repositoryService, RegistryService registryService) throws RepositoryConfigurationException {
        this.repositoryService = repositoryService;
        this.registryService = registryService;
        if (initParams == null) {
            throw new RepositoryConfigurationException("Init parameters expected !!!");
        }
        this.initParams = initParams;
        this.setDefaultMimes();
    }

    public ArtifactManagingServiceImpl(InitParams params, RepositoryService repositoryService) throws RepositoryConfigurationException {
        this(params, repositoryService, null);
    }

    @Override
    public void addArtifact(SessionProvider sp, ArtifactDescriptor artifact, InputStream jarIStream, InputStream pomIStream) throws RepositoryException {
        Session session = this.currentSession(sp);
        Node rootNode = (Node)session.getItem(this.rootNodePath);
        Node groupId_tail = this.createGroupIdLayout(rootNode, artifact);
        Node artifactId_node = this.createArtifactIdLayout(groupId_tail, artifact);
        Node version_node = this.createVersionLayout(artifactId_node, artifact);
        if (version_node != null) {
            this.importResource(version_node, jarIStream, "jar", artifact);
            this.importResource(version_node, pomIStream, "pom", artifact);
        }
        session.save();
    }

    @Override
    public void exportArtifacts(SessionProvider sp, FolderDescriptor parentFolder, OutputStream out) throws RepositoryException, FileNotFoundException {
        Session session = this.currentSession(sp);
        Node parentNode = this.rootNodePath.length() > 1 ? (Node)session.getItem(this.rootNodePath + "/" + parentFolder.getAsPath()) : (Node)session.getItem("/" + parentFolder.getAsPath());
        LOG.info((Object)"Write repository to zipped stream");
        ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(out, 4096));
        try {
            this.mapRepositoryToZipStream(parentNode, zout);
            zout.flush();
            zout.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Cannot write to zip stream", (Throwable)e);
        }
    }

    @Override
    public void exportArtifacts(SessionProvider sp, FolderDescriptor parentFolder, File destFolder) throws RepositoryException, FileNotFoundException {
        Session session = this.currentSession(sp);
        Node parentNode = this.rootNodePath.length() > 1 ? (Node)session.getItem(this.rootNodePath + "/" + parentFolder.getAsPath()) : (Node)session.getItem("/" + parentFolder.getAsPath());
        this.mapRepositoryToFilefs(parentNode, destFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void mapRepositoryToFilefs(Node parentNode, File parentFolder) throws RepositoryException {
        NodeIterator folderIterator = parentNode.getNodes();
        while (folderIterator.hasNext()) {
            Node folder = folderIterator.nextNode();
            if (folder.isNodeType("exo:artifact")) {
                File levelfolder = new File(parentFolder.getAbsoluteFile() + File.separator + folder.getName());
                levelfolder.mkdir();
                this.mapRepositoryToFilefs(folder, levelfolder);
                continue;
            }
            if (!folder.isNodeType("exo:file")) continue;
            File content = new File(parentFolder + File.separator + folder.getName());
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(content);
                Node dataNode = folder.getNode("jcr:content");
                Property data = dataNode.getProperty("jcr:data");
                Property lastModified = dataNode.getProperty("jcr:lastModified");
                content.setLastModified(lastModified.getLong());
                IOUtils.copy((InputStream)data.getStream(), (OutputStream)fout);
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)"!!Can't create content fo file", (Throwable)e);
                IOUtils.closeQuietly((OutputStream)fout);
                continue;
            }
            catch (IOException e2) {
                LOG.error((Object)"!!Can't write content fo file", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fout);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)fout);
                continue;
            }
            IOUtils.closeQuietly((OutputStream)fout);
        }
    }

    private void mapRepositoryToZipStream(Node parentNode, ZipOutputStream zout) throws RepositoryException, IOException {
        NodeIterator folderIterator = parentNode.getNodes();
        while (folderIterator.hasNext()) {
            int count;
            ZipEntry entry;
            String entryName;
            Node folder = folderIterator.nextNode();
            if (folder.isNodeType("exo:artifact")) {
                entryName = parentNode.getPath() + File.separator + folder.getName();
                entry = new ZipEntry(entryName + "/");
                zout.putNextEntry(entry);
                this.mapRepositoryToZipStream(folder, zout);
                continue;
            }
            if (!folder.isNodeType("exo:file")) continue;
            entryName = parentNode.getPath() + File.separator + folder.getName();
            entry = new ZipEntry(entryName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Zipping " + entryName));
            }
            Node dataNode = folder.getNode("jcr:content");
            Property data = dataNode.getProperty("jcr:data");
            InputStream in = data.getStream();
            Property lastModified = dataNode.getProperty("jcr:lastModified");
            entry.setTime(lastModified.getLong());
            entry.setSize(in.available());
            zout.putNextEntry(entry);
            byte[] buf = new byte[4096];
            while ((count = in.read(buf, 0, 4096)) != -1) {
                zout.write(buf, 0, count);
            }
            zout.flush();
            in.close();
        }
    }

    @Override
    public List<Descriptor> getDescriptors(SessionProvider sp, FolderDescriptor parentFolder) throws RepositoryException {
        LOG.info((Object)("Get child nodes to : " + parentFolder.getAsString()));
        Session session = this.currentSession(sp);
        session.refresh(true);
        Node rootNode = (Node)session.getItem(this.rootNodePath);
        String strPath = parentFolder.getAsString();
        Node targetNode = strPath.equals("/") ? rootNode : rootNode.getNode(strPath.substring(1));
        LOG.info((Object)targetNode.getPath());
        NodeType[] a = targetNode.getMixinNodeTypes();
        StringBuilder mixins = new StringBuilder();
        for (NodeType type : a) {
            mixins.append(type.getName()).append(" ");
        }
        LOG.info((Object)("**** Mixins : " + mixins.toString()));
        LOG.info((Object)("**** Workspace : " + session.getWorkspace().getName()));
        ArrayList<Descriptor> childNodes = new ArrayList<Descriptor>();
        NodeIterator iterator = targetNode.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            if (!node.isNodeType("nt:folder") && !node.isNodeType("nt:file")) continue;
            FolderDescriptor descriptor = new FolderDescriptor(node.getName());
            childNodes.add(descriptor);
        }
        return childNodes.size() == 0 ? null : childNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importArtifacts(SessionProvider sp, InputStream in) throws RepositoryException, FileNotFoundException {
        LOG.info((Object)"Extract repository to temporary folder");
        String path = System.getProperty("java.io.tmpdir") + File.separator + "maven2";
        File temporaryFolder = new File(this.getUniqueFilename(path));
        if (!temporaryFolder.mkdir()) {
            throw new FileNotFoundException("Cannot create temporary folder");
        }
        ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(in));
        try {
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                int count;
                if (entry.isDirectory() && new File(temporaryFolder + File.separator + entry.getName()).mkdir()) continue;
                byte[] data = new byte[4096];
                File file = new File(temporaryFolder + File.separator + entry.getName());
                FileUtils.touch((File)file);
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 4096);
                while ((count = zipIn.read(data, 0, 4096)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Cannot get zip entry from stream", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipIn);
            IOUtils.closeQuietly((InputStream)in);
        }
        this.importArtifacts(sp, temporaryFolder);
        try {
            FileUtils.deleteDirectory((File)temporaryFolder);
        }
        catch (IOException e) {
            LOG.error((Object)"Cannot remove temporary folder", (Throwable)e);
        }
    }

    @Override
    public void importArtifacts(SessionProvider sp, File folder) throws RepositoryException, FileNotFoundException {
        if (!folder.exists()) {
            throw new FileNotFoundException("Source folder expected");
        }
        try {
            this.listErrorPom.clear();
            this.importFilesToJCR(sp, folder);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception during uploading local folder to JCR", (Throwable)e);
        }
    }

    private void importFilesToJCR(SessionProvider sp, File folder) throws Exception {
        for (File file : folder.listFiles(new DefaultFileFilter())) {
            String basename;
            File jarfile;
            String ext;
            if (file.isDirectory()) {
                this.importFilesToJCR(sp, file);
            }
            if (!(ext = FilenameUtils.getExtension((String)file.getAbsolutePath())).equals("pom") || !(jarfile = new File((basename = FilenameUtils.removeExtension((String)file.getAbsolutePath())).concat(".jar"))).exists()) continue;
            try {
                ArtifactDescriptor artifact = ArtifactDescriptor.createFromPomfile(file);
                FileInputStream jarIStream = new FileInputStream(jarfile);
                FileInputStream pomIStream = new FileInputStream(file);
                this.addArtifact(sp, artifact, jarIStream, pomIStream);
            }
            catch (SAXParseException e) {
                this.listErrorPom.add(FilenameUtils.getName((String)file.getAbsolutePath()));
            }
        }
    }

    @Override
    public void removeArtifact(SessionProvider sp, Descriptor artifact) throws RepositoryException {
        Session session = this.currentSession(sp);
        Node root = (Node)session.getItem(this.rootNodePath);
        String pathToRemove = "";
        pathToRemove = this.rootNodePath.length() > 1 ? (this.rootNodePath.endsWith("/") ? this.rootNodePath + artifact.getAsPath() : this.rootNodePath + "/" + artifact.getAsPath()) : "/" + artifact.getAsPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Remove node: " + pathToRemove));
        }
        Node rmNode = (Node)session.getItem(pathToRemove);
        rmNode.remove();
        session.save();
    }

    @Override
    public List getPermission(SessionProvider sp, Descriptor artifact) throws RepositoryException {
        Session session = this.currentSession(sp);
        String pathToCheck = "";
        pathToCheck = this.rootNodePath.length() > 1 ? (this.rootNodePath.endsWith("/") ? this.rootNodePath + artifact.getAsPath() : this.rootNodePath + "/" + artifact.getAsPath()) : "/" + artifact.getAsPath();
        LOG.debug((Object)("Checking Permission on node: " + pathToCheck));
        ExtendedNode rmNode = (ExtendedNode)session.getItem(pathToCheck);
        List list = rmNode.getACL().getPermissionEntries();
        return list;
    }

    @Override
    public void changePermission(SessionProvider sp, Descriptor artifact, String identity, String[] permissions, boolean delete) throws RepositoryException {
        Session session = this.currentSession(sp);
        String pathToChange = "";
        pathToChange = this.rootNodePath.length() > 1 ? (this.rootNodePath.endsWith("/") ? this.rootNodePath + artifact.getAsPath() : this.rootNodePath + "/" + artifact.getAsPath()) : "/" + artifact.getAsPath();
        LOG.debug((Object)("Changing Permission on node: " + pathToChange));
        ExtendedNode chNode = (ExtendedNode)session.getItem(pathToChange);
        if (!chNode.isNodeType("exo:privilegeable")) {
            if (chNode.canAddMixin("exo:privilegeable")) {
                chNode.addMixin("exo:privilegeable");
            } else {
                throw new RepositoryException("Can't add mixin");
            }
        }
        try {
            if (!delete) {
                chNode.setPermission(identity, permissions);
            } else if (permissions.length > 0) {
                for (int i = 0; i < permissions.length; ++i) {
                    chNode.removePermission(identity, permissions[i]);
                }
            } else {
                chNode.removePermission(identity);
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Cannot change permissions", (Throwable)e);
        }
        session.save();
    }

    @Override
    public List<Descriptor> searchArtifacts(SessionProvider sp, SearchCriteria criteria) throws RepositoryException {
        Session session = this.currentSession(sp);
        session.refresh(true);
        session.save();
        String param = criteria.getContainsExpr();
        String pathConstraint = "";
        pathConstraint = this.rootNodePath.length() > 1 ? (this.rootNodePath.endsWith("/") ? this.rootNodePath + "%/" + param + "[%]" : this.rootNodePath + "/%/" + param + "[%]") : "/%/" + param + "[%]";
        String sqlQuery = String.format("SELECT * FROM nt:folder WHERE jcr:path LIKE '%s' ", pathConstraint);
        LOG.info((Object)sqlQuery);
        QueryManager manager = session.getWorkspace().getQueryManager();
        Query query = manager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iterator = queryResult.getNodes();
        ArrayList<Descriptor> preciseNode = new ArrayList<Descriptor>();
        while (iterator.hasNext()) {
            Node candidate = iterator.nextNode();
            FolderDescriptor descriptor = new FolderDescriptor(candidate.getPath());
            preciseNode.add(descriptor);
        }
        return preciseNode;
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Starting ArtifactManagingService ...");
        }
        this.sessionProvider = SessionProvider.createSystemProvider();
        try {
            InputStream xml = this.getClass().getResourceAsStream(NT_FILE);
            ManageableRepository rep = this.repositoryService.getCurrentRepository();
            rep.getNodeTypeManager().registerNodeTypes(xml, 0, "text/xml");
            this.readParamsFromRegistryService(this.sessionProvider);
            this.prepareRootNode(this.sessionProvider, this.rootNodePath);
        }
        catch (PathNotFoundException e) {
            try {
                this.readParamsFromFile();
                this.writeParamsToRegistryService(this.sessionProvider);
                this.prepareRootNode(this.sessionProvider, this.rootNodePath);
            }
            catch (RepositoryException exc) {
                LOG.error((Object)"Cannot write init configuration to RegistryService", (Throwable)exc);
            }
            catch (IOException exc) {
                LOG.error((Object)"Cannot write init configuration to RegistryService", (Throwable)exc);
            }
            catch (SAXException exc) {
                LOG.error((Object)"Cannot write init configuration to RegistryService", (Throwable)exc);
            }
            catch (ParserConfigurationException exc) {
                LOG.error((Object)"Cannot write init configuration to RegistryService", (Throwable)exc);
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Error while register nodetypes/checking existance", (Throwable)e);
        }
        finally {
            this.sessionProvider.close();
        }
    }

    public void stop() {
    }

    private Session currentSession(SessionProvider sp) throws RepositoryException {
        return sp.getSession(this.repoWorkspaceName, this.repositoryService.getCurrentRepository());
    }

    private void prepareRootNode(SessionProvider sp, String path) throws RepositoryException {
        Session session = this.currentSession(sp);
        Node current_root = session.getRootNode();
        for (String folder : path.split("/")) {
            if (!current_root.hasNode(folder)) {
                current_root.addNode(folder);
            }
            current_root = current_root.getNode(folder);
        }
        session.save();
        if (!session.getItem(path).isNode()) {
            throw new RepositoryException("Maven root node is not been initialized");
        }
    }

    private Node createGroupIdLayout(Node rootNode, ArtifactDescriptor artifact) throws RepositoryException {
        String[] items;
        FolderDescriptor groupId = artifact.getGroupId();
        ArrayList<String> struct_groupId = new ArrayList<String>();
        for (String subString : items = groupId.getAsPath().split("/")) {
            struct_groupId.add(subString);
        }
        Node groupIdTail = rootNode;
        for (String name : struct_groupId) {
            Node levelNode;
            if (!groupIdTail.hasNode(name)) {
                levelNode = groupIdTail.addNode(name, "nt:folder");
                levelNode.addMixin("exo:groupId");
            } else {
                levelNode = groupIdTail.getNode(name);
            }
            groupIdTail = levelNode;
        }
        return groupIdTail;
    }

    private Node createArtifactIdLayout(Node groupId_NodeTail, ArtifactDescriptor artifact) throws RepositoryException {
        Node artifactIdNode;
        String artifactId = artifact.getArtifactId();
        if (!groupId_NodeTail.hasNode(artifactId)) {
            artifactIdNode = groupId_NodeTail.addNode(artifactId, "nt:folder");
            artifactIdNode.addMixin("exo:artifactId");
            artifactIdNode.setProperty("exo:versionList", new String[]{STRING_TERMINATOR, STRING_TERMINATOR});
        } else {
            artifactIdNode = groupId_NodeTail.getNode(artifactId);
        }
        return artifactIdNode;
    }

    private Node createVersionLayout(Node artifactId, ArtifactDescriptor artifact) throws RepositoryException {
        String version = artifact.getVersionId();
        if (artifactId.hasNode(version)) {
            return null;
        }
        Node currentVersion = artifactId.addNode(version, "nt:folder");
        currentVersion.addMixin("exo:versionId");
        return currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void importResource(Node parentNode, InputStream file_in, String resourceType, ArtifactDescriptor artifact) throws RepositoryException {
        File tmp_file;
        String filename;
        block9: {
            filename = resourceType.equals("metadata") ? "maven-metadata.xml" : String.format("%s-%s.%s", artifact.getArtifactId(), artifact.getVersionId(), resourceType);
            FileOutputStream fout = null;
            tmp_file = null;
            try {
                String tmpFilename = this.getUniqueFilename(filename);
                tmp_file = File.createTempFile(tmpFilename, null);
                fout = new FileOutputStream(tmp_file);
                IOUtils.copy((InputStream)file_in, (OutputStream)fout);
                fout.flush();
                IOUtils.closeQuietly((InputStream)file_in);
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)"Cannot create .tmp file for storing artifact", (Throwable)e);
                break block9;
            }
            catch (IOException e2) {
                LOG.error((Object)"IO exception on .tmp file for storing artifact", (Throwable)e2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)file_in);
                IOUtils.closeQuietly(fout);
            }
            IOUtils.closeQuietly((OutputStream)fout);
        }
        this.writePrimaryContent(parentNode, filename, resourceType, tmp_file);
        this.writeChecksum(parentNode, filename, tmp_file, "SHA1");
        try {
            FileUtils.forceDelete((File)tmp_file);
        }
        catch (IOException e) {
            LOG.error((Object)"Cannot delete tmp file", (Throwable)e);
        }
    }

    private void writePrimaryContent(Node parentNode, String filename, String resourceType, File srcFile) throws RepositoryException {
        String mixinType;
        String mimeType = this.getRelativeMimeType(resourceType);
        Node nodeResourceFile = parentNode.addNode(filename, "nt:file");
        if (nodeResourceFile.canAddMixin(mixinType = "exo:maven".concat(resourceType))) {
            nodeResourceFile.addMixin(mixinType);
        }
        try {
            FileInputStream file_is = new FileInputStream(srcFile);
            Node content = nodeResourceFile.addNode("jcr:content", "nt:resource");
            content.setProperty("jcr:mimeType", mimeType);
            content.setProperty("jcr:lastModified", Calendar.getInstance());
            content.setProperty("jcr:data", (InputStream)file_is);
            IOUtils.closeQuietly((InputStream)file_is);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Cannot read from .tmp resource file", (Throwable)e);
        }
    }

    private void writeChecksum(Node parentNode, String filename, File srcFile, String algorithm) throws RepositoryException {
        String mixinType;
        Node nodeChecksumFile = parentNode.addNode(filename.concat("." + algorithm.toLowerCase()), "nt:file");
        if (nodeChecksumFile.canAddMixin(mixinType = "exo:maven".concat(algorithm.toLowerCase()))) {
            nodeChecksumFile.addMixin(mixinType);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(srcFile);
            String checksum = CRCGenerator.getChecksum(fileInputStream, algorithm);
            ByteArrayInputStream checksum_is = new ByteArrayInputStream(checksum.getBytes());
            String mimeType = "text/plain";
            Node content = nodeChecksumFile.addNode("jcr:content", "nt:resource");
            content.setProperty("jcr:mimeType", mimeType);
            content.setProperty("jcr:lastModified", Calendar.getInstance());
            content.setProperty("jcr:data", (InputStream)checksum_is);
            IOUtils.closeQuietly((InputStream)checksum_is);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Cannot read from .tmp resource file", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Cannot read from .tmp resource file", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"No such algorithm for generating checksums", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createSingleMetadata(String groupId, String artifactId, String version) throws FileNotFoundException {
        File temp = null;
        try {
            String filename = this.getUniqueFilename("maven-metadata.xml");
            temp = File.createTempFile(filename, null);
            FileOutputStream os = new FileOutputStream(temp);
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(os);
            try {
                writer.writeStartDocument("UTF-8", "1.0");
                writer.writeStartElement("metadata");
                writer.writeStartElement("groupId");
                writer.writeCharacters(groupId);
                writer.writeEndElement();
                writer.writeStartElement("artifactId");
                writer.writeCharacters(artifactId);
                writer.writeEndElement();
                writer.writeStartElement("version");
                writer.writeCharacters(version);
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndDocument();
            }
            finally {
                writer.flush();
                writer.close();
                ((OutputStream)os).close();
            }
        }
        catch (XMLStreamException e) {
            LOG.error((Object)"Error on creating metadata - XML", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Error on creating metadata - FILE", (Throwable)e);
        }
        return temp != null && temp.exists() ? temp : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createMultiMetadata(String groupId, String artifactId, String current_version, List<String> v_list) throws FileNotFoundException {
        File temp = null;
        try {
            String filename = this.getUniqueFilename("maven-metadata.xml");
            temp = File.createTempFile(filename, null);
            FileOutputStream os = new FileOutputStream(temp);
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(os);
            try {
                String elderVersion;
                writer.writeStartDocument("UTF-8", "1.0");
                writer.writeStartElement("metadata");
                writer.writeStartElement("groupId");
                writer.writeCharacters(groupId);
                writer.writeEndElement();
                writer.writeStartElement("artifactId");
                writer.writeCharacters(artifactId);
                writer.writeEndElement();
                if (v_list.size() > 0) {
                    Collections.sort(v_list);
                    elderVersion = v_list.get(0);
                } else {
                    elderVersion = current_version;
                }
                v_list.add(current_version);
                writer.writeStartElement("version");
                writer.writeCharacters(elderVersion);
                writer.writeEndElement();
                writer.writeStartElement("versions");
                writer.writeStartElement("versioning");
                Iterator<String> iterator = v_list.iterator();
                while (iterator.hasNext()) {
                    writer.writeStartElement("version");
                    writer.writeCharacters(iterator.next());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndDocument();
            }
            finally {
                writer.flush();
                writer.close();
                ((OutputStream)os).close();
            }
        }
        catch (XMLStreamException e) {
            LOG.error((Object)"Error on creating metadata - XML", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Error on creating metadata - FILE", (Throwable)e);
        }
        return temp != null && temp.exists() ? temp : null;
    }

    private String getRelativeMimeType(String key) {
        return this.mimeMap.get(key);
    }

    private void setDefaultMimes() {
        this.mimeMap.put("jar", "application/java-archive");
        this.mimeMap.put("pom", "text/xml");
    }

    private String getUniqueFilename(String basename) {
        String suffix = Double.valueOf(Math.random()).toString().substring(2, 7);
        return basename + "." + suffix;
    }

    private void readParamsFromRegistryService(SessionProvider sessionProvider) throws PathNotFoundException, RepositoryException {
        String entryPath = "exo:services/ArtifactManaging/workspace";
        RegistryEntry registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        Document doc = registryEntry.getDocument();
        Element element = doc.getDocumentElement();
        this.repoWorkspaceName = this.getAttributeSmart(element, "value");
        entryPath = "exo:services/ArtifactManaging/rootNode";
        registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = registryEntry.getDocument();
        element = doc.getDocumentElement();
        this.rootNodePath = this.getAttributeSmart(element, "value");
        LOG.info((Object)("Workspace from RegistryService: " + this.repoWorkspaceName));
        LOG.info((Object)("RootNode from RegistryService: " + this.rootNodePath));
    }

    private void writeParamsToRegistryService(SessionProvider sessionProvider) throws IOException, SAXException, ParserConfigurationException, RepositoryException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement(SERVICE_NAME);
        doc.appendChild(root);
        Element element = doc.createElement("workspace");
        this.setAttributeSmart(element, "value", this.repoWorkspaceName);
        root.appendChild(element);
        element = doc.createElement("rootNode");
        this.setAttributeSmart(element, "value", this.rootNodePath);
        root.appendChild(element);
        RegistryEntry serviceEntry = new RegistryEntry(doc);
        this.registryService.createEntry(sessionProvider, "exo:services", serviceEntry);
    }

    private String getAttributeSmart(Element element, String attr) {
        return element.hasAttribute(attr) ? element.getAttribute(attr) : null;
    }

    private void setAttributeSmart(Element element, String attr, String value) {
        if (value == null) {
            element.removeAttribute(attr);
        } else {
            element.setAttribute(attr, value);
        }
    }

    private void readParamsFromFile() {
        PropertiesParam props = this.initParams.getPropertiesParam("artifact.workspace");
        if (props == null) {
            throw new IllegalArgumentException("Property parameters 'locations' expected");
        }
        this.repoWorkspaceName = props.getProperty("workspace");
        this.rootNodePath = props.getProperty("rootNode");
        LOG.info((Object)("Workspace from configuration file: " + this.repoWorkspaceName));
        LOG.info((Object)("RootNode from configuration file: " + this.rootNodePath));
    }

    @Override
    public List getListErrors() {
        return this.listErrorPom;
    }
}

