/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.File;
import javax.jcr.RepositoryException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.RepositoryIndexSearcherHolder;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCService;

@NameTemplate(value={@Property(key="service", value="SystemSearchManager")})
public class SystemSearchManager
extends SearchManager {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SystemSearchManager");
    private boolean isStarted = false;
    public static final String INDEX_DIR_SUFFIX = "system";

    public SystemSearchManager(ExoContainerContext ctx, WorkspaceEntry wEntry, RepositoryEntry rEntry, RepositoryService rService, QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeDataManager ntReg, WorkspacePersistentDataManager itemMgr, DocumentReaderService service, ConfigurationManager cfm, RepositoryIndexSearcherHolder indexSearcherHolder, RPCService rpcService, FileCleanerHolder cleanerHolder) throws RepositoryException, RepositoryConfigurationException {
        super(ctx, wEntry, rEntry, rService, config, nsReg, ntReg, itemMgr, null, service, cfm, indexSearcherHolder, rpcService, cleanerHolder);
    }

    public SystemSearchManager(ExoContainerContext ctx, WorkspaceEntry wEntry, RepositoryEntry rEntry, RepositoryService rService, QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeDataManager ntReg, WorkspacePersistentDataManager itemMgr, DocumentReaderService service, ConfigurationManager cfm, RepositoryIndexSearcherHolder indexSearcherHolder, FileCleanerHolder cleanerHolder) throws RepositoryException, RepositoryConfigurationException {
        this(ctx, wEntry, rEntry, rService, config, nsReg, ntReg, itemMgr, service, cfm, indexSearcherHolder, null, cleanerHolder);
    }

    @Override
    public void start() {
        if (!this.isStarted) {
            try {
                if (this.indexingTree == null) {
                    NodeData indexingRootNodeData = (NodeData)this.itemMgr.getItemData("00exo0jcr0system0uuid00000000000");
                    this.indexingTree = new IndexingTree(indexingRootNodeData, null);
                }
                this.initializeQueryHandler();
            }
            catch (RepositoryException e) {
                LOG.error((Object)e.getLocalizedMessage());
                this.handler = null;
                throw new RuntimeException(e);
            }
            catch (RepositoryConfigurationException e) {
                LOG.error((Object)e.getLocalizedMessage());
                this.handler = null;
                throw new RuntimeException(e);
            }
            this.isStarted = true;
        }
    }

    @Override
    protected File getIndexDirectory() throws RepositoryConfigurationException {
        return new File(this.getIndexDirParam() + "_" + INDEX_DIR_SUFFIX);
    }

    @Override
    protected String getStorageName() {
        return super.getStorageName() + "_" + INDEX_DIR_SUFFIX;
    }
}

