/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.jcr.impl.core.query.lucene.TwoWayRangeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeIteratorImpl
implements TwoWayRangeIterator,
NodeIterator {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.NodeIteratorImpl");
    protected final ScoreNodeIterator scoreNodes;
    private final int selectorIndex;
    protected final SessionDataManager itemMgr;
    protected int invalid = 0;
    private NodeImpl next;
    private boolean initialized;

    NodeIteratorImpl(SessionDataManager itemMgr, ScoreNodeIterator scoreNodes, int selectorIndex) {
        this.itemMgr = itemMgr;
        this.scoreNodes = scoreNodes;
        this.selectorIndex = selectorIndex;
    }

    public long getPosition() {
        this.initialize();
        long position = this.scoreNodes.getPosition() - (long)this.invalid;
        if (this.next != null) {
            --position;
        }
        return position;
    }

    public long getSize() {
        long size = this.scoreNodes.getSize();
        if (size == -1L) {
            return size;
        }
        return size - (long)this.invalid;
    }

    public boolean hasNext() {
        this.initialize();
        return this.next != null;
    }

    public Object next() throws NoSuchElementException {
        this.initialize();
        return this.nextNode();
    }

    public Node nextNode() throws NoSuchElementException {
        this.initialize();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        NodeImpl n = this.next;
        this.fetchNext();
        return n;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.initialize();
        if (skipNum > 0L) {
            this.scoreNodes.skip(skipNum - 1L);
            this.fetchNext();
        }
    }

    @Override
    public void skipBack(long skipNum) {
        this.initialize();
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        this.scoreNodes.skipBack(skipNum + 1L);
        this.fetchNext();
    }

    protected void fetchNext() {
        this.next = null;
        while (this.next == null && this.scoreNodes.hasNext()) {
            ScoreNode[] sn = this.scoreNodes.nextScoreNodes();
            try {
                this.next = (NodeImpl)this.itemMgr.getItemByIdentifier(sn[this.selectorIndex].getNodeId(), true);
                if (this.next != null) continue;
                ++this.invalid;
            }
            catch (RepositoryException e) {
                log.warn("Exception retrieving Node with UUID: " + sn[this.selectorIndex].getNodeId() + ": " + e.toString());
                ++this.invalid;
            }
        }
    }

    protected void initialize() {
        if (!this.initialized) {
            this.fetchNext();
            this.initialized = true;
        }
    }
}

