/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.dataflow.PathValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public class PathPersistedValueData
extends PathValueData
implements PersistedValueData {
    public PathPersistedValueData() {
        super(0, null);
    }

    public PathPersistedValueData(int orderNumber, QPath value) {
        super(orderNumber, value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orderNumber = in.readInt();
        byte[] data = new byte[in.readInt()];
        if (data.length > 0) {
            in.readFully(data);
            try {
                this.value = QPath.parse(new String(data, "UTF-8"));
            }
            catch (IllegalPathException e) {
                throw new IOException(e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.orderNumber);
        byte[] data = this.value.getAsString().getBytes("UTF-8");
        out.writeInt(data.length);
        if (data.length > 0) {
            out.write(data);
        }
    }
}

