/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SingleDbJDBCConnection;

public class OracleSingleDbJDBCConnection
extends SingleDbJDBCConnection {
    protected static final String FIND_NODES_BY_PARENTID_CQ_QUERY = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_SITEM I, JCR_SITEM P, JCR_SVALUE V where I.I_CLASS=1 and I.CONTAINER_NAME=? and I.PARENT_ID=? and P.I_CLASS=2 and P.CONTAINER_NAME=? and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID".replaceFirst("select", "select /*+ INDEX(I JCR_IDX_SITEM_PARENT_ID) INDEX(P JCR_IDX_SITEM_PARENT_ID) INDEX(V JCR_IDX_SVALUE_PROPERTY)*/");
    protected static final String FIND_PROPERTIES_BY_PARENTID_CQ_QUERY = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from JCR_SITEM I LEFT OUTER JOIN JCR_SVALUE V ON (V.PROPERTY_ID=I.ID) where I.I_CLASS=2 and I.CONTAINER_NAME=? and I.PARENT_ID=? order by I.NAME".replaceFirst("select", "select /*+ INDEX(I JCR_IDX_SITEM_PARENT_ID) INDEX(V JCR_IDX_SVALUE_PROPERTY)*/");
    protected static final String FIND_ITEM_QPATH_BY_ID_CQ_QUERY = "select I.ID, I.PARENT_ID, I.NAME, I.I_INDEX from JCR_SITEM I, (SELECT ID, PARENT_ID from JCR_SITEM where ID=?) J where I.ID = J.ID or I.ID = J.PARENT_ID".replaceFirst("SELECT", "SELECT /*+ INDEX(JCR_SITEM JCR_PK_SITEM) */");

    public OracleSingleDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    @Override
    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_NODES_BY_PARENTID_CQ = FIND_NODES_BY_PARENTID_CQ_QUERY;
        this.FIND_PROPERTIES_BY_PARENTID_CQ = FIND_PROPERTIES_BY_PARENTID_CQ_QUERY;
        this.FIND_ITEM_QPATH_BY_ID_CQ = FIND_ITEM_QPATH_BY_ID_CQ_QUERY;
        this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE = "select /*+ INDEX(I JCR_FK_SITEM_PARENT) INDEX(V JCR_IDX_SVALUE_PROPERTY)*/ I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from JCR_SITEM I LEFT OUTER JOIN JCR_SVALUE V ON (V.PROPERTY_ID=I.ID)";
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_SVALUE V, JCR_SITEM P join ( select * from ( select A.*, ROWNUM r__ from ( select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from JCR_SITEM I  where I.CONTAINER_NAME=? and I.I_CLASS=1 order by I.ID ) A where ROWNUM <= ?) where r__ > ?) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and V.PROPERTY_ID=P.ID order by J.ID";
        if (this.containerConfig.useSequenceForOrderNumber) {
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = "select /*+ USE_NL(V) INDEX(I JCR_IDX_SITEM_N_ORDER_NUM) INDEX(P JCR_IDX_SITEM_PARENT_FK) INDEX(V JCR_IDX_SVALUE_PROPERTY) */ I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_SVALUE V, JCR_SITEM P  join ( select * from ( select A.*, ROWNUM r__ from ( select J.* from JCR_SITEM J  where J.CONTAINER_NAME=? and J.I_CLASS=1 and J.PARENT_ID=? order by J.N_ORDER_NUM, J.ID  ) A where ROWNUM <= ?) where r__ > ?) I on P.PARENT_ID = I.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
            this.FIND_LAST_ORDER_NUMBER = "SELECT " + this.JCR_ITEM_NEXT_VAL + " ('" + this.JCR_ITEM_SEQ + "', ?, ?) FROM dual";
        } else {
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = this.FIND_NODES_BY_PARENTID_LAZILY_CQ.replaceFirst("select", "select /*+ USE_NL(V) INDEX(I JCR_IDX_SITEM_N_ORDER_NUM) INDEX(P JCR_IDX_SITEM_PARENT_FK) INDEX(V JCR_IDX_SVALUE_PROPERTY) */ ");
        }
        this.FIND_ITEM_BY_NAME = this.FIND_ITEM_BY_NAME.replaceFirst("select", "select /*+ INDEX(I JCR_IDX_SITEM_PARENT) */");
        this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ = this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ.replaceFirst("select", "select /*+ INDEX(I JCR_IDX_SITEM_PARENT_NAME) */");
        this.DELETE_ITEM = "delete /*+ INDEX(I JCR_PK_SITEM)*/ from JCR_SITEM I where I.ID=?";
    }

    @Override
    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties == null) {
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES);
        } else {
            this.findNodesAndProperties.clearParameters();
        }
        this.findNodesAndProperties.setString(1, this.containerConfig.containerName);
        this.findNodesAndProperties.setInt(2, offset + limit);
        this.findNodesAndProperties.setInt(3, offset);
        this.findNodesAndProperties.setString(4, this.containerConfig.containerName);
        return this.findNodesAndProperties.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int offset, int limit) throws SQLException {
        if (!this.containerConfig.useSequenceForOrderNumber) {
            return super.findChildNodesByParentIdentifier(parentCid, fromOrderNum, offset, limit);
        }
        if (this.findNodesByParentIdLazilyCQ == null) {
            this.findNodesByParentIdLazilyCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_LAZILY_CQ);
        } else {
            this.findNodesByParentIdLazilyCQ.clearParameters();
        }
        this.findNodesByParentIdLazilyCQ.setString(1, this.containerConfig.containerName);
        this.findNodesByParentIdLazilyCQ.setString(2, parentCid);
        this.findNodesByParentIdLazilyCQ.setInt(3, offset + limit);
        this.findNodesByParentIdLazilyCQ.setInt(4, offset);
        this.findNodesByParentIdLazilyCQ.setString(5, this.containerConfig.containerName);
        return this.findNodesByParentIdLazilyCQ.executeQuery();
    }
}

