/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.WeakHashMap;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SpoolFile
extends File {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SpoolFile");
    protected Map<Object, Long> users = new WeakHashMap<Object, Long>();

    public SpoolFile(File parent, String child) {
        super(parent, child);
    }

    public SpoolFile(String absPath) {
        super(absPath);
    }

    public static SpoolFile createTempFile(String prefix, String suffix, File directory) throws IOException {
        return new SpoolFile(PrivilegedFileHelper.getAbsolutePath((File)PrivilegedFileHelper.createTempFile((String)prefix, (String)suffix, (File)directory)));
    }

    public synchronized void acquire(Object holder) throws FileNotFoundException {
        if (this.users == null) {
            throw new FileNotFoundException("File was deleted " + PrivilegedFileHelper.getAbsolutePath((File)this));
        }
        this.users.put(holder, System.currentTimeMillis());
    }

    public synchronized void release(Object holder) throws FileNotFoundException {
        if (this.users == null) {
            throw new FileNotFoundException("File was deleted " + PrivilegedFileHelper.getAbsolutePath((File)this));
        }
        this.users.remove(holder);
    }

    public synchronized boolean inUse() throws FileNotFoundException {
        if (this.users == null) {
            throw new FileNotFoundException("File was deleted " + PrivilegedFileHelper.getAbsolutePath((File)this));
        }
        return this.users.size() > 0;
    }

    @Override
    public synchronized boolean delete() {
        if (this.users != null && this.users.size() <= 0) {
            this.users.clear();
            this.users = null;
            final SpoolFile sf = this;
            PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return sf.exists() ? SpoolFile.super.delete() : true;
                }
            };
            return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
        }
        return false;
    }
}

