/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jcr.Session;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SessionReference
extends WeakReference<Session> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SessionReference");
    private static final int INITIAL_DELAY = 10;
    private static final int DELAY = 15;
    private static ScheduledExecutorService executor;
    private static ConcurrentHashMap<Object, SessionReference> objects;
    private static volatile boolean started;
    private static long maxAgeMillis_;
    private static final Runnable detectorTask;
    private final StackTraceElement[] stack = new Exception().getStackTrace();
    private final Object key = new Object();
    private final long timestamp = System.currentTimeMillis() + maxAgeMillis_;
    volatile boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void start(long maxAgeMillis) {
        if (started) return;
        Class<SessionReference> clazz = SessionReference.class;
        synchronized (SessionReference.class) {
            if (started) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            if (maxAgeMillis < 0L) {
                throw new IllegalStateException("Wrong max age value " + maxAgeMillis);
            }
            objects = new ConcurrentHashMap();
            executor = Executors.newSingleThreadScheduledExecutor();
            executor.scheduleWithFixedDelay(detectorTask, 10L, 15L, TimeUnit.SECONDS);
            maxAgeMillis_ = maxAgeMillis;
            started = true;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isStarted() {
        return started;
    }

    SessionReference(Session referent) {
        super(referent);
        objects.put(this.key, this);
    }

    static {
        started = false;
        detectorTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOG.info((Object)"Starting detector task");
                Class<SessionReference> clazz = SessionReference.class;
                synchronized (SessionReference.class) {
                    ArrayList<SessionReference> list = new ArrayList<SessionReference>(objects.values());
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    for (SessionReference ref : list) {
                        if (ref.closed) {
                            objects.remove(ref.key);
                            continue;
                        }
                        Session session = (Session)ref.get();
                        String error = null;
                        if (session == null) {
                            error = "garbagednotclosed";
                        } else if (ref.timestamp < System.currentTimeMillis()) {
                            error = "expired";
                        }
                        if (error == null) continue;
                        objects.remove(ref.key);
                        Exception e = new Exception();
                        e.setStackTrace(ref.stack);
                        LOG.error((Object)("<" + error + ">"));
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        LOG.error((Object)("</" + error + ">"));
                    }
                    LOG.info((Object)"Finished detector task");
                    return;
                }
            }
        };
    }
}

