/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.app;

import javax.jcr.RepositoryException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.spi.DefinitionByType;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

@DefinitionByType(type=ThreadLocalSessionProviderService.class)
public interface SessionProviderService {
    public void setSessionProvider(Object var1, SessionProvider var2);

    public SessionProvider getSessionProvider(Object var1);

    public SessionProvider getSystemSessionProvider(Object var1);

    public void removeSessionProvider(Object var1);

    public static SessionProvider getSystemSessionProvider() {
        SessionProviderService sessionProviderService = SessionProviderService.getSessionProviderService();
        return sessionProviderService.getSystemSessionProvider(null);
    }

    public static ManageableRepository getRepository() {
        try {
            return SessionProviderService.getRepositoryService().getCurrentRepository();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public static SessionProviderService getSessionProviderService() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container == null || container.getComponentInstanceOfType(SessionProviderService.class) == null) {
            container = PortalContainer.getInstance();
        }
        return (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
    }

    public static RepositoryService getRepositoryService() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container == null || container.getComponentInstanceOfType(RepositoryService.class) == null) {
            container = PortalContainer.getInstance();
        }
        return (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
    }
}

