/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.distribution.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.ext.distribution.impl.AbstractDataDistributionType;
import org.exoplatform.services.jcr.impl.core.NodeImpl;

public class DataDistributionByName
extends AbstractDataDistributionType {
    private int depth = 4;
    private String suffix = "___";

    @Override
    protected List<String> getAncestors(String dataId) {
        ArrayList<String> result = new ArrayList<String>(this.depth);
        int length = dataId.length();
        for (int i = 0; i < this.depth - 1 && i < length - 1; ++i) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(dataId, 0, i + 1);
            buffer.append(this.suffix);
            result.add(buffer.toString());
        }
        result.add(dataId);
        return result;
    }

    @Override
    protected boolean useParametersOnLeafOnly() {
        return true;
    }

    @Override
    public void migrate(Node rootNode) throws RepositoryException {
        this.migrate(rootNode, null, null, null);
    }

    @Override
    public void migrate(Node rootNode, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws RepositoryException {
        NodeIterator iter = ((NodeImpl)rootNode).getNodesLazily();
        while (iter.hasNext()) {
            Node userNode = iter.nextNode();
            if (this.alreadyMigrated(userNode)) continue;
            Node ancestorNode = rootNode;
            Iterator<String> ancestors = this.getAncestors(userNode.getName()).iterator();
            while (ancestors.hasNext()) {
                String ancestorName = ancestors.next();
                if (ancestors.hasNext()) {
                    try {
                        ancestorNode = ancestorNode.getNode(ancestorName);
                    }
                    catch (PathNotFoundException e) {
                        ancestorNode = this.createNode(ancestorNode, ancestorName, nodeType, mixinTypes, permissions, false, false);
                    }
                    continue;
                }
                rootNode.getSession().move(userNode.getPath(), ancestorNode.getPath() + "/" + ancestorName);
            }
            rootNode.getSession().save();
        }
    }

    private boolean alreadyMigrated(Node userNode) throws RepositoryException {
        String nodeName = userNode.getName();
        return nodeName.length() == 1 || nodeName.endsWith(this.suffix);
    }
}

