/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.sat;

import java.util.ArrayList;
import java.util.List;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;

public class BoundingBoxHelper {
    private double maxR;
    private double maxR2;
    private Projection proj;

    public BoundingBoxHelper(Projection proj, double maxR) {
        this.proj = proj;
        this.maxR = maxR;
        this.maxR2 = maxR * maxR;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProjectionRect latLonToProjBB(LatLonRect rect) {
        ProjectionPoint llpt = this.proj.latLonToProj(rect.getLowerLeftPoint(), new ProjectionPointImpl());
        ProjectionPoint urpt = this.proj.latLonToProj(rect.getUpperRightPoint(), new ProjectionPointImpl());
        ProjectionPoint lrpt = this.proj.latLonToProj(rect.getLowerRightPoint(), new ProjectionPointImpl());
        ProjectionPoint ulpt = this.proj.latLonToProj(rect.getUpperLeftPoint(), new ProjectionPointImpl());
        ArrayList<ProjectionPoint> goodPts = new ArrayList<ProjectionPoint>(4);
        int countBad = 0;
        if (!this.addGoodPts(goodPts, llpt)) {
            ++countBad;
        }
        if (!this.addGoodPts(goodPts, urpt)) {
            ++countBad;
        }
        if (!this.addGoodPts(goodPts, lrpt)) {
            ++countBad;
        }
        if (!this.addGoodPts(goodPts, ulpt)) {
            ++countBad;
        }
        if (countBad == 2) {
            if (!ProjectionPointImpl.isInfinite(llpt) && !ProjectionPointImpl.isInfinite(lrpt)) {
                this.addGoodPts(goodPts, new ProjectionPointImpl(0.0, this.maxR));
                return this.makeRect(goodPts);
            } else if (!ProjectionPointImpl.isInfinite(ulpt) && !ProjectionPointImpl.isInfinite(llpt)) {
                this.addGoodPts(goodPts, new ProjectionPointImpl(this.maxR, 0.0));
                return this.makeRect(goodPts);
            } else if (!ProjectionPointImpl.isInfinite(ulpt) && !ProjectionPointImpl.isInfinite(urpt)) {
                this.addGoodPts(goodPts, new ProjectionPointImpl(0.0, -this.maxR));
                return this.makeRect(goodPts);
            } else {
                if (ProjectionPointImpl.isInfinite(urpt) || ProjectionPointImpl.isInfinite(lrpt)) throw new IllegalStateException();
                this.addGoodPts(goodPts, new ProjectionPointImpl(-this.maxR, 0.0));
            }
            return this.makeRect(goodPts);
        } else {
            if (countBad != 3) return this.makeRect(goodPts);
            if (!ProjectionPointImpl.isInfinite(llpt)) {
                double xcoord = llpt.getX();
                this.addGoodPts(goodPts, new ProjectionPointImpl(xcoord, this.getLimitCoord(xcoord)));
                double ycoord = llpt.getY();
                this.addGoodPts(goodPts, new ProjectionPointImpl(this.getLimitCoord(ycoord), ycoord));
                return this.makeRect(goodPts);
            } else if (!ProjectionPointImpl.isInfinite(urpt)) {
                double xcoord = urpt.getX();
                this.addGoodPts(goodPts, new ProjectionPointImpl(xcoord, -this.getLimitCoord(xcoord)));
                double ycoord = urpt.getY();
                this.addGoodPts(goodPts, new ProjectionPointImpl(-this.getLimitCoord(ycoord), ycoord));
                return this.makeRect(goodPts);
            } else if (!ProjectionPointImpl.isInfinite(ulpt)) {
                double xcoord = ulpt.getX();
                this.addGoodPts(goodPts, new ProjectionPointImpl(xcoord, -this.getLimitCoord(xcoord)));
                double ycoord = ulpt.getY();
                this.addGoodPts(goodPts, new ProjectionPointImpl(this.getLimitCoord(ycoord), ycoord));
                return this.makeRect(goodPts);
            } else {
                if (ProjectionPointImpl.isInfinite(lrpt)) throw new IllegalStateException();
                double xcoord = lrpt.getX();
                this.addGoodPts(goodPts, new ProjectionPointImpl(xcoord, this.getLimitCoord(xcoord)));
                double ycoord = lrpt.getY();
                this.addGoodPts(goodPts, new ProjectionPointImpl(-this.getLimitCoord(ycoord), ycoord));
            }
        }
        return this.makeRect(goodPts);
    }

    private boolean addGoodPts(List<ProjectionPoint> goodPts, ProjectionPoint pt) {
        if (!ProjectionPointImpl.isInfinite(pt)) {
            goodPts.add(pt);
            return true;
        }
        return false;
    }

    private double getLimitCoord(double coord) {
        return Math.sqrt(this.maxR2 - coord * coord);
    }

    private ProjectionRect makeRect(List<ProjectionPoint> goodPts) {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        for (ProjectionPoint pp : goodPts) {
            minx = Math.min(minx, pp.getX());
            maxx = Math.max(maxx, pp.getX());
            miny = Math.min(miny, pp.getY());
            maxy = Math.max(maxy, pp.getY());
        }
        return new ProjectionRect(minx, miny, maxx, maxy);
    }
}

