/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.EnumSet;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.EnhanceScaleMissing;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.Misc;

class EnhanceScaleMissingImpl
implements EnhanceScaleMissing {
    private static final byte NC_FILL_BYTE = -127;
    private static final char NC_FILL_CHAR = '\u0000';
    private static final short NC_FILL_SHORT = -32767;
    private static final int NC_FILL_INT = -2147483647;
    private static final float NC_FILL_FLOAT = 9.96921E36f;
    private static final double NC_FILL_DOUBLE = (double)9.96921E36f;
    private static final boolean debug = false;
    private static final boolean debugRead = false;
    private static final boolean debugMissing = false;
    private DataType convertedDataType = null;
    private boolean useNaNs = false;
    private boolean invalidDataIsMissing = NetcdfDataset.invalidDataIsMissing;
    private boolean fillValueIsMissing = NetcdfDataset.fillValueIsMissing;
    private boolean missingDataIsMissing = NetcdfDataset.missingDataIsMissing;
    private boolean hasScaleOffset = false;
    private double scale = 1.0;
    private double offset = 0.0;
    private boolean hasValidRange = false;
    private boolean hasValidMin = false;
    private boolean hasValidMax = false;
    private double valid_min = -1.7976931348623157E308;
    private double valid_max = Double.MAX_VALUE;
    private boolean hasFillValue = false;
    private double fillValue;
    private boolean hasMissingValue = false;
    private double[] missingValue;
    private boolean isUnsigned;

    EnhanceScaleMissingImpl() {
    }

    EnhanceScaleMissingImpl(VariableDS forVar) {
        this(forVar, NetcdfDataset.useNaNs, NetcdfDataset.fillValueIsMissing, NetcdfDataset.invalidDataIsMissing, NetcdfDataset.missingDataIsMissing);
    }

    EnhanceScaleMissingImpl(VariableDS forVar, boolean useNaNs, boolean fillValueIsMissing, boolean invalidDataIsMissing, boolean missingDataIsMissing) {
        boolean hasMissing;
        double[] values;
        boolean hasValidData;
        Attribute validRangeAtt;
        VariableDS orgVarDS;
        EnumSet<NetcdfDataset.Enhance> orgEnhanceMode;
        this.fillValueIsMissing = fillValueIsMissing;
        this.invalidDataIsMissing = invalidDataIsMissing;
        this.missingDataIsMissing = missingDataIsMissing;
        Variable orgVar = forVar.getOriginalVariable();
        if (orgVar instanceof VariableDS && (orgEnhanceMode = (orgVarDS = (VariableDS)orgVar).getEnhanceMode()) != null && orgEnhanceMode.contains((Object)NetcdfDataset.Enhance.ScaleMissing)) {
            return;
        }
        this.isUnsigned = forVar.isUnsigned();
        this.convertedDataType = forVar.getDataType();
        DataType scaleType = null;
        DataType missType = null;
        DataType validType = null;
        DataType fillType = null;
        Attribute att = forVar.findAttribute("scale_factor");
        if (null != att && !att.isString()) {
            this.scale = att.getNumericValue().doubleValue();
            this.hasScaleOffset = true;
            scaleType = att.getDataType();
            forVar.remove(att);
        }
        if (null != (att = forVar.findAttribute("add_offset")) && !att.isString()) {
            this.offset = att.getNumericValue().doubleValue();
            this.hasScaleOffset = true;
            DataType offType = att.getDataType();
            if (this.rank(offType) > this.rank(scaleType)) {
                scaleType = offType;
            }
            forVar.remove(att);
        }
        if (null != (validRangeAtt = forVar.findAttribute("valid_range")) && !validRangeAtt.isString() && validRangeAtt.getLength() > 1) {
            this.valid_min = validRangeAtt.getNumericValue(0).doubleValue();
            this.valid_max = validRangeAtt.getNumericValue(1).doubleValue();
            this.hasValidRange = true;
            validType = validRangeAtt.getDataType();
            if (this.hasScaleOffset) {
                forVar.remove(validRangeAtt);
            }
        }
        Attribute validMinAtt = null;
        Attribute validMaxAtt = null;
        if (!this.hasValidRange) {
            validMinAtt = forVar.findAttribute("valid_min");
            if (null != validMinAtt && !validMinAtt.isString()) {
                this.valid_min = validMinAtt.getNumericValue().doubleValue();
                this.hasValidMin = true;
                validType = validMinAtt.getDataType();
                if (this.hasScaleOffset) {
                    forVar.remove(validMinAtt);
                }
            }
            if (null != (validMaxAtt = forVar.findAttribute("valid_max")) && !validMaxAtt.isString()) {
                this.valid_max = validMaxAtt.getNumericValue().doubleValue();
                this.hasValidMax = true;
                DataType t = validMaxAtt.getDataType();
                if (this.rank(t) > this.rank(validType)) {
                    validType = t;
                }
                if (this.hasScaleOffset) {
                    forVar.remove(validMaxAtt);
                }
            }
        }
        boolean bl = hasValidData = this.hasValidMin || this.hasValidMax || this.hasValidRange;
        if (this.hasValidMin && this.hasValidMax) {
            this.hasValidRange = true;
        }
        if (null != (att = forVar.findAttribute("_FillValue")) && !att.isString() && (values = this.getValueAsDouble(att)).length > 0) {
            this.fillValue = values[0];
            this.hasFillValue = true;
            fillType = att.getDataType();
            if (this.hasScaleOffset) {
                forVar.remove(att);
            }
        }
        if (null != (att = forVar.findAttribute("missing_value"))) {
            if (att.isString()) {
                String svalue = att.getStringValue();
                if (forVar.getDataType() == DataType.CHAR) {
                    this.missingValue = new double[1];
                    this.missingValue[0] = svalue.length() == 0 ? 0.0 : (double)svalue.charAt(0);
                    missType = DataType.CHAR;
                    this.hasMissingValue = true;
                } else {
                    try {
                        this.missingValue = new double[1];
                        this.missingValue[0] = Double.parseDouble(svalue);
                        missType = att.getDataType();
                        this.hasMissingValue = true;
                    }
                    catch (NumberFormatException ex) {}
                }
            } else {
                this.missingValue = this.getValueAsDouble(att);
                missType = att.getDataType();
                this.hasMissingValue = true;
            }
            if (this.hasScaleOffset) {
                forVar.remove(att);
            }
        }
        boolean bl2 = hasMissing = invalidDataIsMissing && hasValidData || fillValueIsMissing && this.hasFillValue || missingDataIsMissing && this.hasMissingValue;
        if (this.hasScaleOffset) {
            this.convertedDataType = forVar.getDataType();
            if (hasMissing) {
                if (this.rank(scaleType) > this.rank(this.convertedDataType)) {
                    this.convertedDataType = scaleType;
                }
                if (missingDataIsMissing && this.rank(missType) > this.rank(this.convertedDataType)) {
                    this.convertedDataType = missType;
                }
                if (fillValueIsMissing && this.rank(fillType) > this.rank(this.convertedDataType)) {
                    this.convertedDataType = fillType;
                }
                if (invalidDataIsMissing && this.rank(validType) > this.rank(this.convertedDataType)) {
                    this.convertedDataType = validType;
                }
                if (this.rank(this.convertedDataType) < this.rank(DataType.DOUBLE)) {
                    this.convertedDataType = DataType.FLOAT;
                }
            } else if (this.rank(scaleType) > this.rank(this.convertedDataType)) {
                this.convertedDataType = scaleType;
            }
            if (hasValidData) {
                DataType orgType = forVar.getDataType();
                if (this.rank(validType) != this.rank(scaleType) || this.rank(scaleType) < this.rank(orgType)) {
                    if (validRangeAtt != null) {
                        double[] values2 = this.getValueAsDouble(validRangeAtt);
                        this.valid_min = values2[0];
                        this.valid_max = values2[1];
                    } else {
                        double[] values3;
                        if (validMinAtt != null) {
                            values3 = this.getValueAsDouble(validMinAtt);
                            this.valid_min = values3[0];
                        }
                        if (validMaxAtt != null) {
                            values3 = this.getValueAsDouble(validMaxAtt);
                            this.valid_max = values3[0];
                        }
                    }
                }
            }
        }
        if (hasMissing && (this.convertedDataType == DataType.DOUBLE || this.convertedDataType == DataType.FLOAT)) {
            this.useNaNs = useNaNs;
        }
    }

    private double[] getValueAsDouble(Attribute att) {
        int n = att.getLength();
        double[] value = new double[n];
        for (int i = 0; i < n; ++i) {
            value[i] = this.isUnsigned && att.getDataType() == DataType.BYTE ? this.convertScaleOffsetMissing(att.getNumericValue(i).byteValue()) : (this.isUnsigned && att.getDataType() == DataType.SHORT ? this.convertScaleOffsetMissing(att.getNumericValue(i).shortValue()) : (this.isUnsigned && att.getDataType() == DataType.INT ? this.convertScaleOffsetMissing(att.getNumericValue(i).intValue()) : this.scale * att.getNumericValue(i).doubleValue() + this.offset));
        }
        return value;
    }

    private int rank(DataType c) {
        if (c == DataType.BYTE) {
            return 0;
        }
        if (c == DataType.SHORT) {
            return 1;
        }
        if (c == DataType.INT) {
            return 2;
        }
        if (c == DataType.LONG) {
            return 3;
        }
        if (c == DataType.FLOAT) {
            return 4;
        }
        if (c == DataType.DOUBLE) {
            return 5;
        }
        return -1;
    }

    public DataType getConvertedDataType() {
        return this.convertedDataType;
    }

    @Override
    public boolean hasInvalidData() {
        return this.hasValidRange || this.hasValidMin || this.hasValidMax;
    }

    @Override
    public double getValidMin() {
        return this.valid_min;
    }

    @Override
    public double getValidMax() {
        return this.valid_max;
    }

    @Override
    public boolean isInvalidData(double val) {
        if (this.hasValidRange) {
            return val < this.valid_min || val > this.valid_max;
        }
        if (this.hasValidMin) {
            return val < this.valid_min;
        }
        if (this.hasValidMax) {
            return val > this.valid_max;
        }
        return false;
    }

    @Override
    public boolean hasFillValue() {
        return this.hasFillValue;
    }

    @Override
    public boolean isFillValue(double val) {
        return this.hasFillValue && val == this.fillValue;
    }

    public double getFillValue() {
        return this.fillValue;
    }

    @Override
    public boolean hasScaleOffset() {
        return this.hasScaleOffset;
    }

    @Override
    public boolean hasMissingValue() {
        return this.hasMissingValue;
    }

    @Override
    public boolean isMissingValue(double val) {
        if (!this.hasMissingValue) {
            return false;
        }
        for (double aMissingValue : this.missingValue) {
            if (!Misc.closeEnough(val, aMissingValue)) continue;
            return true;
        }
        return false;
    }

    public double[] getMissingValues() {
        return this.missingValue;
    }

    @Override
    public void setUseNaNs(boolean useNaNs) {
        this.useNaNs = useNaNs;
    }

    @Override
    public boolean getUseNaNs() {
        return this.useNaNs;
    }

    @Override
    public void setFillValueIsMissing(boolean b) {
        this.fillValueIsMissing = b;
    }

    @Override
    public void setInvalidDataIsMissing(boolean b) {
        this.invalidDataIsMissing = b;
    }

    @Override
    public void setMissingDataIsMissing(boolean b) {
        this.missingDataIsMissing = b;
    }

    @Override
    public boolean hasMissing() {
        return this.invalidDataIsMissing && this.hasInvalidData() || this.fillValueIsMissing && this.hasFillValue() || this.missingDataIsMissing && this.hasMissingValue();
    }

    @Override
    public boolean isMissing(double val) {
        if (Double.isNaN(val)) {
            return true;
        }
        return this.hasMissing() && this.isMissing_(val);
    }

    @Override
    public boolean isMissingFast(double val) {
        if (this.useNaNs) {
            return Double.isNaN(val);
        }
        if (Double.isNaN(val)) {
            return true;
        }
        return this.hasMissing() && this.isMissing_(val);
    }

    private boolean isMissing_(double val) {
        if (this.missingDataIsMissing && this.hasMissingValue && this.isMissingValue(val)) {
            return true;
        }
        if (this.fillValueIsMissing && this.hasFillValue && this.isFillValue(val)) {
            return true;
        }
        if (this.invalidDataIsMissing) {
            return this.isInvalidData(val);
        }
        return false;
    }

    public Object getFillValue(DataType dt) {
        DataType useType;
        DataType dataType = useType = this.convertedDataType == null ? dt : this.convertedDataType;
        if (useType == DataType.BYTE || useType == DataType.ENUM1) {
            byte[] result = new byte[]{this.hasFillValue ? (byte)this.fillValue : (byte)-127};
            return result;
        }
        if (useType == DataType.BOOLEAN) {
            boolean[] result = new boolean[]{false};
            return result;
        }
        if (useType == DataType.CHAR) {
            char[] result = new char[]{this.hasFillValue ? (char)this.fillValue : (char)'\u0000'};
            return result;
        }
        if (useType == DataType.SHORT || useType == DataType.ENUM2) {
            short[] result = new short[]{this.hasFillValue ? (short)this.fillValue : (short)-32767};
            return result;
        }
        if (useType == DataType.INT || useType == DataType.ENUM4) {
            int[] result = new int[]{this.hasFillValue ? (int)this.fillValue : -2147483647};
            return result;
        }
        if (useType == DataType.LONG) {
            long[] result = new long[]{this.hasFillValue ? (long)this.fillValue : -2147483647L};
            return result;
        }
        if (useType == DataType.FLOAT) {
            float[] result = new float[]{this.hasFillValue ? (float)this.fillValue : 9.96921E36f};
            return result;
        }
        if (useType == DataType.DOUBLE) {
            double[] result = new double[]{this.hasFillValue ? this.fillValue : (double)9.96921E36f};
            return result;
        }
        String[] result = new String[]{"_FillValue"};
        return result;
    }

    @Override
    public double convertScaleOffsetMissing(byte valb) {
        if (!this.hasScaleOffset) {
            return this.useNaNs && this.isMissing(valb) ? Double.NaN : (double)valb;
        }
        double convertedValue = this.isUnsigned ? this.scale * (double)DataType.unsignedByteToShort(valb) + this.offset : this.scale * (double)valb + this.offset;
        return this.useNaNs && this.isMissing(convertedValue) ? Double.NaN : convertedValue;
    }

    @Override
    public double convertScaleOffsetMissing(short vals) {
        if (!this.hasScaleOffset) {
            return this.useNaNs && this.isMissing(vals) ? Double.NaN : (double)vals;
        }
        double convertedValue = this.isUnsigned ? this.scale * (double)DataType.unsignedShortToInt(vals) + this.offset : this.scale * (double)vals + this.offset;
        return this.useNaNs && this.isMissing(convertedValue) ? Double.NaN : convertedValue;
    }

    @Override
    public double convertScaleOffsetMissing(int vali) {
        if (!this.hasScaleOffset) {
            return this.useNaNs && this.isMissing(vali) ? Double.NaN : (double)vali;
        }
        double convertedValue = this.isUnsigned ? this.scale * (double)DataType.unsignedIntToLong(vali) + this.offset : this.scale * (double)vali + this.offset;
        return this.useNaNs && this.isMissing(convertedValue) ? Double.NaN : convertedValue;
    }

    @Override
    public double convertScaleOffsetMissing(long vall) {
        if (!this.hasScaleOffset) {
            return this.useNaNs && this.isMissing(vall) ? Double.NaN : (double)vall;
        }
        double convertedValue = this.scale * (double)vall + this.offset;
        return this.useNaNs && this.isMissing(convertedValue) ? Double.NaN : convertedValue;
    }

    @Override
    public double convertScaleOffsetMissing(double value) {
        if (!this.hasScaleOffset) {
            return this.useNaNs && this.isMissing(value) ? Double.NaN : value;
        }
        double convertedValue = this.scale * value + this.offset;
        return this.useNaNs && this.isMissing(convertedValue) ? Double.NaN : convertedValue;
    }

    @Override
    public Array convertScaleOffsetMissing(Array data) {
        if (this.hasScaleOffset()) {
            data = this.convertScaleOffset(data);
        } else if (this.hasMissing() && this.getUseNaNs()) {
            data = this.convertMissing(data);
        }
        return data;
    }

    private Array convertScaleOffset(Array in) {
        if (!this.hasScaleOffset) {
            return in;
        }
        Array out = Array.factory(this.convertedDataType.getPrimitiveClassType(), in.getShape());
        IndexIterator iterIn = in.getIndexIterator();
        IndexIterator iterOut = out.getIndexIterator();
        if (this.isUnsigned && in.getElementType() == Byte.TYPE) {
            this.convertScaleOffsetUnsignedByte(iterIn, iterOut);
        } else if (this.isUnsigned && in.getElementType() == Short.TYPE) {
            this.convertScaleOffsetUnsignedShort(iterIn, iterOut);
        } else if (this.isUnsigned && in.getElementType() == Integer.TYPE) {
            this.convertScaleOffsetUnsignedInt(iterIn, iterOut);
        } else {
            boolean checkMissing;
            boolean bl = checkMissing = this.useNaNs && this.hasMissing();
            while (iterIn.hasNext()) {
                double val = this.scale * iterIn.getDoubleNext() + this.offset;
                iterOut.setDoubleNext(checkMissing && this.isMissing_(val) ? Double.NaN : val);
            }
        }
        return out;
    }

    private void convertScaleOffsetUnsignedByte(IndexIterator iterIn, IndexIterator iterOut) {
        boolean checkMissing;
        boolean bl = checkMissing = this.useNaNs && this.hasMissing();
        while (iterIn.hasNext()) {
            byte valb = iterIn.getByteNext();
            double val = this.scale * (double)DataType.unsignedByteToShort(valb) + this.offset;
            iterOut.setDoubleNext(checkMissing && this.isMissing_(val) ? Double.NaN : val);
        }
    }

    private void convertScaleOffsetUnsignedShort(IndexIterator iterIn, IndexIterator iterOut) {
        boolean checkMissing;
        boolean bl = checkMissing = this.useNaNs && this.hasMissing();
        while (iterIn.hasNext()) {
            short valb = iterIn.getShortNext();
            double val = this.scale * (double)DataType.unsignedShortToInt(valb) + this.offset;
            iterOut.setDoubleNext(checkMissing && this.isMissing_(val) ? Double.NaN : val);
        }
    }

    private void convertScaleOffsetUnsignedInt(IndexIterator iterIn, IndexIterator iterOut) {
        boolean checkMissing;
        boolean bl = checkMissing = this.useNaNs && this.hasMissing();
        while (iterIn.hasNext()) {
            int valb = iterIn.getIntNext();
            double val = this.scale * (double)DataType.unsignedIntToLong(valb) + this.offset;
            iterOut.setDoubleNext(checkMissing && this.isMissing_(val) ? Double.NaN : val);
        }
    }

    private Array convertMissing(Array in) {
        block3: {
            IndexIterator iterIn;
            block2: {
                iterIn = in.getIndexIterator();
                if (in.getElementType() != Double.TYPE) break block2;
                while (iterIn.hasNext()) {
                    double val = iterIn.getDoubleNext();
                    if (!this.isMissing_(val)) continue;
                    iterIn.setDoubleCurrent(Double.NaN);
                }
                break block3;
            }
            if (in.getElementType() != Float.TYPE) break block3;
            while (iterIn.hasNext()) {
                float val = iterIn.getFloatNext();
                if (!this.isMissing_(val)) continue;
                iterIn.setFloatCurrent(Float.NaN);
            }
        }
        return in;
    }

    public float[] setMissingToNaN(float[] values) {
        if (!this.hasMissing()) {
            return values;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!this.isMissing_(values[i])) continue;
            values[i] = Float.NaN;
        }
        return values;
    }

    public static void main(String[] args) {
        double d = Double.NaN;
        float f = (float)d;
        System.out.println(" f=" + f + " " + Float.isNaN(f) + " " + Double.isNaN(f));
    }
}

