/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.storage.CanNotProbeException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.Characters;

public abstract class FirstKeywordPeek {
    protected static final int REJECT = 0;
    protected static final int ACCEPT = 1;
    protected static final int IGNORE = 2;
    static final int READ_AHEAD_LIMIT = 2048;
    protected static final char COMMENT = '#';
    protected final int maxLength;

    public FirstKeywordPeek(int n) {
        this.maxLength = n;
    }

    protected Path getAuxiliaryPath(StorageConnector storageConnector) throws DataStoreException {
        return null;
    }

    private static int nextAfterSpaces(ByteBuffer byteBuffer, Reader reader) throws IOException {
        int n;
        if (byteBuffer != null) {
            while (byteBuffer.hasRemaining()) {
                char c = (char)byteBuffer.get();
                if (Character.isWhitespace(c)) continue;
                return c;
            }
            return -1;
        }
        while ((n = IOUtilities.readCodePoint(reader)) >= 0 && Character.isWhitespace(n)) {
        }
        return n;
    }

    private static void toEndOfLine(ByteBuffer byteBuffer, Reader reader) throws IOException {
        int n;
        do {
            if (byteBuffer != null) {
                if (!byteBuffer.hasRemaining()) break;
                n = (char)byteBuffer.get();
                continue;
            }
            n = IOUtilities.readCodePoint(reader);
            if (n < 0) break;
        } while (!Characters.isLineOrParagraphSeparator((int)n));
    }

    protected int isKeywordChar(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n == 95 ? 1 : 0;
    }

    public final ProbeResult probeContent(DataStoreProvider dataStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        try {
            Reader reader;
            ByteBuffer byteBuffer = storageConnector.getStorageAs(ByteBuffer.class);
            if (byteBuffer != null) {
                byteBuffer.mark();
                reader = null;
            } else {
                reader = storageConnector.getStorageAs(Reader.class);
                if (reader != null) {
                    reader.mark(2048);
                } else {
                    Path path = this.getAuxiliaryPath(storageConnector);
                    if (path != null) {
                        return this.probeContent(path);
                    }
                    return ProbeResult.UNSUPPORTED_STORAGE;
                }
            }
            return this.probeContent(byteBuffer, reader);
        }
        catch (IOException iOException) {
            throw new CanNotProbeException(dataStoreProvider, storageConnector, (Throwable)iOException);
        }
    }

    public final ProbeResult probeContent(Path path) throws DataStoreException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.maxLength + 100);
        try {
            try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, new OpenOption[0]);){
                int n;
                while ((n = seekableByteChannel.read(byteBuffer)) >= 0 && byteBuffer.hasRemaining()) {
                }
            }
            return this.probeContent((ByteBuffer)byteBuffer.flip().mark(), null);
        }
        catch (IOException iOException) {
            throw new DataStoreException(iOException);
        }
    }

    private ProbeResult probeContent(ByteBuffer byteBuffer, Reader reader) throws IOException {
        int n;
        char[] cArray = null;
        int n2 = 0;
        while ((n = FirstKeywordPeek.nextAfterSpaces(byteBuffer, reader)) == 35) {
            FirstKeywordPeek.toEndOfLine(byteBuffer, reader);
        }
        int n3 = this.isKeywordChar(n);
        if (n3 >= 1) {
            cArray = new char[this.maxLength];
            do {
                if (n3 != 1) continue;
                if (n2 >= cArray.length) {
                    n2 = 0;
                    break;
                }
                cArray[n2++] = (char)n;
            } while ((n3 = this.isKeywordChar(n = byteBuffer != null ? (byteBuffer.hasRemaining() ? (int)byteBuffer.get() : -1) : IOUtilities.readCodePoint(reader))) >= 1);
            if (Character.isWhitespace(n)) {
                n = FirstKeywordPeek.nextAfterSpaces(byteBuffer, reader);
            }
            if (!this.isPostKeyword(n)) {
                n2 = 0;
            }
        }
        if (byteBuffer != null) {
            byteBuffer.reset();
        } else {
            reader.reset();
        }
        if (n < 0) {
            return ProbeResult.INSUFFICIENT_BYTES;
        }
        if (n2 == 0) {
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
        return this.forKeyword(cArray, n2);
    }

    protected abstract boolean isPostKeyword(int var1);

    protected abstract ProbeResult forKeyword(char[] var1, int var2);
}

