/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MSXExcelSheetXMLHandler
extends DefaultHandler {
    private static final Log LOG = ExoLogger.getExoLogger((String)"exo.core.component.document.MSXExcelSheetXMLHandler");
    private ReadOnlySharedStringsTable sharedStringsTable;
    private long maxCellsToParse = -1L;
    private long currentCellsParsed = 0L;
    private final SheetContentsHandler output;
    private boolean vIsOpen;
    private boolean isIsOpen;
    private boolean hfIsOpen;
    private xssfDataType nextDataType;
    private String cellRef;
    private StringBuilder value = new StringBuilder();
    private StringBuilder headerFooter = new StringBuilder();

    public MSXExcelSheetXMLHandler(ReadOnlySharedStringsTable strings, SheetContentsHandler sheetContentsHandler, long maxCellsToParse) {
        this.sharedStringsTable = strings;
        this.output = sheetContentsHandler;
        this.nextDataType = xssfDataType.NUMBER;
        this.maxCellsToParse = maxCellsToParse;
    }

    private boolean isTextTag(String name) {
        if ("v".equals(name)) {
            return true;
        }
        if ("inlineStr".equals(name)) {
            return true;
        }
        return "t".equals(name) && this.isIsOpen;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.isTextTag(name)) {
            this.vIsOpen = true;
            this.value.setLength(0);
        } else if ("is".equals(name)) {
            this.isIsOpen = true;
        } else if ("f".equals(name)) {
            if (this.nextDataType == xssfDataType.NUMBER) {
                this.nextDataType = xssfDataType.FORMULA;
            }
        } else if ("oddHeader".equals(name) || "evenHeader".equals(name) || "firstHeader".equals(name) || "firstFooter".equals(name) || "oddFooter".equals(name) || "evenFooter".equals(name)) {
            this.hfIsOpen = true;
            this.headerFooter.setLength(0);
        } else if ("row".equals(name)) {
            this.output.startRow(0);
        } else if ("c".equals(name)) {
            this.nextDataType = xssfDataType.NUMBER;
            this.cellRef = attributes.getValue("r");
            String cellType = attributes.getValue("t");
            if ("b".equals(cellType)) {
                this.nextDataType = xssfDataType.BOOLEAN;
            } else if ("e".equals(cellType)) {
                this.nextDataType = xssfDataType.ERROR;
            } else if ("inlineStr".equals(cellType)) {
                this.nextDataType = xssfDataType.INLINE_STRING;
            } else if ("s".equals(cellType)) {
                this.nextDataType = xssfDataType.SST_STRING;
            } else if ("str".equals(cellType)) {
                this.nextDataType = xssfDataType.FORMULA;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        block20: {
            block19: {
                thisStr = null;
                if (!this.isTextTag(name)) break block19;
                this.vIsOpen = false;
                switch (1.$SwitchMap$org$exoplatform$services$document$impl$MSXExcelSheetXMLHandler$xssfDataType[this.nextDataType.ordinal()]) {
                    case 1: {
                        ++this.currentCellsParsed;
                        break;
                    }
                    case 2: {
                        ++this.currentCellsParsed;
                        break;
                    }
                    case 3: {
                        ++this.currentCellsParsed;
                        break;
                    }
                    case 4: {
                        rtsi = new XSSFRichTextString(this.value.toString());
                        thisStr = rtsi.toString();
                        ++this.currentCellsParsed;
                        break;
                    }
                    case 5: {
                        sstIndex = this.value.toString();
                        try {
                            idx = Integer.parseInt(sstIndex);
                            rtss = this.sharedStringsTable.getItemAt(idx);
                            thisStr = rtss.toString();
                        }
                        catch (NumberFormatException ex) {
                            if (!MSXExcelSheetXMLHandler.LOG.isTraceEnabled()) ** GOTO lbl29
                            MSXExcelSheetXMLHandler.LOG.trace((Object)("Failed to parse SST index '" + sstIndex + "': " + ex.toString()));
                        }
lbl29:
                        // 3 sources

                        ++this.currentCellsParsed;
                        break;
                    }
                    case 6: {
                        ++this.currentCellsParsed;
                        break;
                    }
                    default: {
                        if (MSXExcelSheetXMLHandler.LOG.isTraceEnabled()) {
                            MSXExcelSheetXMLHandler.LOG.trace((Object)("Failed to define the unexpected type '" + this.nextDataType + "'"));
                        }
                        ++this.currentCellsParsed;
                    }
                }
                this.output.cell(this.cellRef, thisStr);
                break block20;
            }
            if ("is".equals(name)) {
                this.isIsOpen = false;
            } else if ("row".equals(name)) {
                this.output.endRow();
            } else if ("oddHeader".equals(name) || "evenHeader".equals(name) || "firstHeader".equals(name)) {
                this.hfIsOpen = false;
                this.output.headerFooter(this.headerFooter.toString(), true, name);
            } else if ("oddFooter".equals(name) || "evenFooter".equals(name) || "firstFooter".equals(name)) {
                this.hfIsOpen = false;
            }
        }
        if (this.maxCellsToParse >= 0L && this.currentCellsParsed > this.maxCellsToParse) {
            throw new StopSheetParsingException("Maximum number of cells to parse per sheet reached (max=" + this.maxCellsToParse + ")");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(ch, start, length);
        }
        if (this.hfIsOpen) {
            this.headerFooter.append(ch, start, length);
        }
    }

    public static interface SheetContentsHandler {
        public void startRow(int var1);

        public void endRow();

        public void cell(String var1, String var2);

        public void headerFooter(String var1, boolean var2, String var3);
    }

    static enum xssfDataType {
        BOOLEAN,
        ERROR,
        FORMULA,
        INLINE_STRING,
        SST_STRING,
        NUMBER;

    }

    public class StopSheetParsingException
    extends SAXException {
        public StopSheetParsingException(String message) {
            super(message);
        }
    }
}

