/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.dasl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.QueryResult;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.webdav.resource.CollectionResource;
import org.exoplatform.services.jcr.webdav.resource.FileResource;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.resource.VersionedCollectionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedFileResource;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.PropertyWriteUtil;
import org.exoplatform.services.jcr.webdav.xml.PropstatGroupedRepresentation;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SearchResultResponseEntity
implements StreamingOutput {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.webdav.SearchResultResponseEntity");
    private final WebDavNamespaceContext nsContext;
    private QueryResult queryResult;
    private String baseURI;
    private static Set<QName> properties = new HashSet<QName>();

    public SearchResultResponseEntity(QueryResult queryResult, WebDavNamespaceContext nsContext, String baseURI) {
        this.queryResult = queryResult;
        this.nsContext = nsContext;
        this.baseURI = baseURI;
    }

    public void write(OutputStream outStream) throws IOException {
        try {
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outStream, "UTF-8");
            xmlStreamWriter.setNamespaceContext(this.nsContext);
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
            xmlStreamWriter.writeNamespace("D", "DAV:");
            xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
            NodeIterator nodeIter = this.queryResult.getNodes();
            HashSet<URI> resultNodes = new HashSet<URI>();
            while (nodeIter.hasNext()) {
                URI uri;
                Node nextNode = nodeIter.nextNode();
                if (nextNode.isNodeType("nt:resource")) {
                    if (!nextNode.getParent().isNodeType("nt:file")) continue;
                    nextNode = nextNode.getParent();
                }
                if (!resultNodes.add(uri = new URI(TextUtil.escape(this.baseURI + nextNode.getPath(), '%', true)))) continue;
                GenericResource resource = ResourceUtil.isVersioned(nextNode) ? (ResourceUtil.isFile(nextNode) ? new VersionedFileResource(uri, nextNode, this.nsContext) : new VersionedCollectionResource(uri, nextNode, this.nsContext)) : (ResourceUtil.isFile(nextNode) ? new FileResource(uri, nextNode, this.nsContext) : new CollectionResource(uri, nextNode, this.nsContext));
                xmlStreamWriter.writeStartElement("DAV:", "response");
                xmlStreamWriter.writeStartElement("DAV:", "href");
                xmlStreamWriter.writeCharacters(resource.getIdentifier().toASCIIString());
                xmlStreamWriter.writeEndElement();
                PropstatGroupedRepresentation propstat = new PropstatGroupedRepresentation(resource, properties, false);
                PropertyWriteUtil.writePropStats(xmlStreamWriter, propstat.getPropStats());
                xmlStreamWriter.writeEndElement();
            }
            resultNodes.clear();
            resultNodes = null;
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException exc) {
            throw new IOException(exc.getMessage(), exc);
        }
        catch (Exception exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            throw new IOException(exc.getMessage(), exc);
        }
    }

    static {
        properties.add(new QName("DAV:", "displayname"));
        properties.add(new QName("DAV:", "resourcetype"));
        properties.add(new QName("DAV:", "creationdate"));
        properties.add(new QName("DAV:", "getlastmodified"));
        properties.add(new QName("DAV:", "getcontentlength"));
        properties.add(new QName("DAV:", "getcontenttype"));
    }
}

