/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public final class X364
extends Enum<X364> {
    public static final /* enum */ X364 RESET = new X364(0, null);
    public static final /* enum */ X364 NORMAL = new X364(22, null);
    public static final /* enum */ X364 BOLD = new X364(1, null);
    public static final /* enum */ X364 FAINT = new X364(2, null);
    public static final /* enum */ X364 UNDERLINE = new X364(4, null);
    public static final /* enum */ X364 NO_UNDERLINE = new X364(24, null);
    public static final /* enum */ X364 FOREGROUND_RED = new X364(31, "red");
    public static final /* enum */ X364 FOREGROUND_GREEN = new X364(32, "green");
    public static final /* enum */ X364 FOREGROUND_YELLOW = new X364(33, "yellow");
    public static final /* enum */ X364 FOREGROUND_BLUE = new X364(34, "blue");
    public static final /* enum */ X364 FOREGROUND_MAGENTA = new X364(35, "magenta");
    public static final /* enum */ X364 FOREGROUND_CYAN = new X364(36, "cyan");
    public static final /* enum */ X364 FOREGROUND_GRAY = new X364(37, "gray");
    public static final /* enum */ X364 FOREGROUND_DEFAULT = new X364(39, null);
    public static final /* enum */ X364 BACKGROUND_RED = new X364(FOREGROUND_RED);
    public static final /* enum */ X364 BACKGROUND_GREEN = new X364(FOREGROUND_GREEN);
    public static final /* enum */ X364 BACKGROUND_YELLOW = new X364(FOREGROUND_YELLOW);
    public static final /* enum */ X364 BACKGROUND_BLUE = new X364(FOREGROUND_BLUE);
    public static final /* enum */ X364 BACKGROUND_MAGENTA = new X364(FOREGROUND_MAGENTA);
    public static final /* enum */ X364 BACKGROUND_CYAN = new X364(FOREGROUND_CYAN);
    public static final /* enum */ X364 BACKGROUND_GRAY = new X364(FOREGROUND_GRAY);
    public static final /* enum */ X364 BACKGROUND_DEFAULT = new X364(FOREGROUND_DEFAULT);
    private static final X364[] NAMED;
    public static final char ESCAPE = '\u001b';
    public static final char BRACKET = '[';
    private static final String START = "\u001b[";
    private static final char END = 'm';
    private final transient byte code;
    private transient String sequence;
    private transient X364 foreground;
    private transient X364 background;
    public final String color;
    private static final /* synthetic */ X364[] $VALUES;

    public static X364[] values() {
        return (X364[])$VALUES.clone();
    }

    public static X364 valueOf(String string) {
        return Enum.valueOf(X364.class, string);
    }

    private X364(byte by, String string2) {
        this.code = by;
        this.color = string2;
        this.foreground = this;
        this.background = this;
    }

    private X364(X364 x364) {
        this((byte)(x364.code + 10), x364.color);
        this.foreground = x364;
        this.background = x364.background = this;
    }

    public X364 foreground() {
        return this.foreground;
    }

    public X364 background() {
        return this.background;
    }

    public String sequence() {
        if (this.sequence == null) {
            this.sequence = (START + this.code + 'm').intern();
        }
        return this.sequence;
    }

    public static CharSequence plain(CharSequence charSequence, int n, int n2) {
        int n3 = CharSequences.indexOf(charSequence, START, n, n2);
        if (n3 >= 0) {
            StringBuilder stringBuilder = null;
            block0: do {
                int n4 = n3;
                int n5 = CharSequences.indexOf(charSequence, 109, n3 += START.length(), n2);
                if (n5 < 0) break;
                while (n3 < n5) {
                    char c;
                    if ((c = charSequence.charAt(n3++)) >= '0' && c <= '9') continue;
                    continue block0;
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n2 - n);
                }
                stringBuilder.append(charSequence, n, n4);
                n = ++n3;
            } while ((n3 = CharSequences.indexOf(charSequence, START, n3, n2)) >= 0);
            if (stringBuilder != null) {
                return stringBuilder.append(charSequence, n, n2);
            }
        }
        return charSequence.subSequence(n, n2);
    }

    public static int lengthOfPlain(CharSequence charSequence, int n, int n2) {
        int n3 = CharSequences.indexOf(charSequence, START, n, n2);
        if (n3 < 0) {
            return CharSequences.codePointCount(charSequence, n, n2);
        }
        int n4 = n;
        int n5 = 0;
        block0: do {
            int n6 = n3;
            int n7 = CharSequences.indexOf(charSequence, 109, n3 += START.length(), n2);
            if (n7 < 0) break;
            while (n3 < n7) {
                char c;
                if ((c = charSequence.charAt(n3++)) >= '0' && c <= '9') continue;
                continue block0;
            }
            n5 += CharSequences.codePointCount(charSequence, n4, n6);
            n4 = ++n3;
        } while ((n3 = CharSequences.indexOf(charSequence, START, n3, n2)) >= 0);
        assert (CharSequences.codePointCount(X364.plain(charSequence, n, n2)) == (n5 += CharSequences.codePointCount(charSequence, n4, n2))) : charSequence.subSequence(n, n2);
        return n5;
    }

    public static X364 forColorName(String string) throws IllegalArgumentException {
        string = CharSequences.trimWhitespaces(string);
        ArgumentChecks.ensureNonEmpty("color", string);
        for (X364 x364 : NAMED) {
            if (!string.equalsIgnoreCase(x364.color)) continue;
            return x364;
        }
        throw new IllegalArgumentException(Errors.format((short)45, "color", string));
    }

    public static boolean isAnsiSupported() {
        String string;
        try {
            string = System.getenv("COLORTERM");
            if (string != null) {
                return true;
            }
            string = System.getenv("CLICOLOR");
        }
        catch (SecurityException securityException) {
            return false;
        }
        if (string != null) {
            try {
                return Integer.parseInt(string) != 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static /* synthetic */ X364[] $values() {
        return new X364[]{RESET, NORMAL, BOLD, FAINT, UNDERLINE, NO_UNDERLINE, FOREGROUND_RED, FOREGROUND_GREEN, FOREGROUND_YELLOW, FOREGROUND_BLUE, FOREGROUND_MAGENTA, FOREGROUND_CYAN, FOREGROUND_GRAY, FOREGROUND_DEFAULT, BACKGROUND_RED, BACKGROUND_GREEN, BACKGROUND_YELLOW, BACKGROUND_BLUE, BACKGROUND_MAGENTA, BACKGROUND_CYAN, BACKGROUND_GRAY, BACKGROUND_DEFAULT};
    }

    static {
        $VALUES = X364.$values();
        NAMED = Arrays.copyOfRange(X364.values(), 6, 13);
    }
}

